/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server;

import io.quarkus.test.junit.QuarkusTest;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.server.BaseClientAuthTest;

@QuarkusTest
class TestBasicAuthentication
extends BaseClientAuthTest {
    TestBasicAuthentication() {
    }

    @Test
    void testValidCredentials() {
        this.withClientCustomizer(c -> c.withAuthType(NessieClient.AuthType.BASIC).withUsername("test_user").withPassword("test_user"));
        Assertions.assertThat((List)this.client().getTreeApi().getAllReferences()).isNotEmpty();
    }

    @Test
    void testValidAdminCredentials() {
        this.withClientCustomizer(c -> c.withAuthType(NessieClient.AuthType.BASIC).withUsername("admin_user").withPassword("test123"));
        Assertions.assertThat((List)this.client().getTreeApi().getAllReferences()).isNotEmpty();
    }

    @Test
    void testInvalidCredentials() {
        this.withClientCustomizer(c -> c.withAuthType(NessieClient.AuthType.BASIC).withUsername("test_user").withPassword("bad_password"));
        Assertions.assertThatThrownBy(() -> this.client().getTreeApi().getAllReferences()).isInstanceOfSatisfying(NessieNotAuthorizedException.class, e -> Assertions.assertThat((int)e.getError().getStatus()).isEqualTo(401));
    }
}

