/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.google.common.base.Throwables;
import java.util.function.Consumer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.projectnessie.error.NessieError;
import org.projectnessie.services.config.ServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExceptionMapper<T extends Throwable>
implements ExceptionMapper<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseExceptionMapper.class);
    private final ServerConfig serverConfig;

    protected BaseExceptionMapper(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    protected Response buildExceptionResponse(int status, String reason, String message, Exception e) {
        return this.buildExceptionResponse(status, reason, message, e, this.serverConfig.sendStacktraceToClient(), h -> {});
    }

    protected Response buildExceptionResponse(int status, String reason, String message, Exception e, boolean includeExceptionStackTrace, Consumer<Response.ResponseBuilder> responseHandler) {
        String stack = includeExceptionStackTrace ? Throwables.getStackTraceAsString((Throwable)e) : null;
        NessieError error = new NessieError(message, status, reason, stack);
        LOGGER.debug("Failure on server, propagated to client. Status: {} {}, Message: {}.", new Object[]{status, reason, message, e});
        Response.ResponseBuilder responseBuilder = Response.status((int)status).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE);
        responseHandler.accept(responseBuilder);
        return responseBuilder.build();
    }
}

