/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.http.HttpContentsApi;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.MultiGetContentsRequest;
import org.projectnessie.model.MultiGetContentsResponse;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.ContentsApiImplWithAuthorization;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
public class RestContentsResource
implements HttpContentsApi {
    private final ServerConfig config;
    private final VersionStore<Contents, CommitMeta, Contents.Type> store;
    private final AccessChecker accessChecker;
    @Context
    SecurityContext securityContext;

    public RestContentsResource() {
        this(null, null, null);
    }

    @Inject
    public RestContentsResource(ServerConfig config, VersionStore<Contents, CommitMeta, Contents.Type> store, AccessChecker accessChecker) {
        this.config = config;
        this.store = store;
        this.accessChecker = accessChecker;
    }

    private ContentsApi resource() {
        return new ContentsApiImplWithAuthorization(this.config, this.store, this.accessChecker, this.securityContext == null ? null : this.securityContext.getUserPrincipal());
    }

    public Contents getContents(ContentsKey key, String ref, String hashOnRef) throws NessieNotFoundException {
        return this.resource().getContents(key, ref, hashOnRef);
    }

    public MultiGetContentsResponse getMultipleContents(String ref, String hashOnRef, MultiGetContentsRequest request) throws NessieNotFoundException {
        return this.resource().getMultipleContents(ref, hashOnRef, request);
    }
}

