/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.http.HttpTreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Transplant;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.TreeApiImplWithAuthorization;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
public class RestTreeResource
implements HttpTreeApi {
    private final ServerConfig config;
    private final VersionStore<Contents, CommitMeta, Contents.Type> store;
    private final AccessChecker accessChecker;
    @Context
    SecurityContext securityContext;

    public RestTreeResource() {
        this(null, null, null);
    }

    @Inject
    public RestTreeResource(ServerConfig config, VersionStore<Contents, CommitMeta, Contents.Type> store, AccessChecker accessChecker) {
        this.config = config;
        this.store = store;
        this.accessChecker = accessChecker;
    }

    private TreeApi resource() {
        return new TreeApiImplWithAuthorization(this.config, this.store, this.accessChecker, this.securityContext == null ? null : this.securityContext.getUserPrincipal());
    }

    public List<Reference> getAllReferences() {
        return this.resource().getAllReferences();
    }

    public Branch getDefaultBranch() throws NessieNotFoundException {
        return this.resource().getDefaultBranch();
    }

    public Reference createReference(String sourceRefName, Reference reference) throws NessieNotFoundException, NessieConflictException {
        return this.resource().createReference(sourceRefName, reference);
    }

    public Reference getReferenceByName(String refName) throws NessieNotFoundException {
        return this.resource().getReferenceByName(refName);
    }

    public EntriesResponse getEntries(String refName, EntriesParams params) throws NessieNotFoundException {
        return this.resource().getEntries(refName, params);
    }

    public LogResponse getCommitLog(String ref, CommitLogParams params) throws NessieNotFoundException {
        return this.resource().getCommitLog(ref, params);
    }

    public void assignTag(String tagName, String oldHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.resource().assignTag(tagName, oldHash, assignTo);
    }

    public void deleteTag(String tagName, String hash) throws NessieConflictException, NessieNotFoundException {
        this.resource().deleteTag(tagName, hash);
    }

    public void assignBranch(String branchName, String oldHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.resource().assignBranch(branchName, oldHash, assignTo);
    }

    public void deleteBranch(String branchName, String hash) throws NessieConflictException, NessieNotFoundException {
        this.resource().deleteBranch(branchName, hash);
    }

    public void transplantCommitsIntoBranch(String branchName, String hash, String message, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        this.resource().transplantCommitsIntoBranch(branchName, hash, message, transplant);
    }

    public void mergeRefIntoBranch(String branchName, String hash, Merge merge) throws NessieNotFoundException, NessieConflictException {
        this.resource().mergeRefIntoBranch(branchName, hash, merge);
    }

    public Branch commitMultipleOperations(String branchName, String hash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        return this.resource().commitMultipleOperations(branchName, hash, operations);
    }
}

