/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.rest.BaseExceptionMapper;

@Provider
public class ValidationExceptionMapper
extends BaseExceptionMapper<ValidationException> {
    public ValidationExceptionMapper() {
        this(null);
    }

    @Inject
    public ValidationExceptionMapper(ServerConfig config) {
        super(config);
    }

    public Response toResponse(ValidationException exception) {
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)exception;
            Response.Status status = Response.Status.BAD_REQUEST;
            for (ConstraintViolation violation : cve.getConstraintViolations()) {
                for (Path.Node node : violation.getPropertyPath()) {
                    ElementKind kind = node.getKind();
                    if (!ElementKind.RETURN_VALUE.equals((Object)kind)) continue;
                    status = Response.Status.INTERNAL_SERVER_ERROR;
                }
            }
            return this.buildExceptionResponse(status.getStatusCode(), status.getReasonPhrase(), exception.getMessage(), (Exception)exception, false, header -> {});
        }
        return this.buildExceptionResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), this.unwrapException((Throwable)exception), (Exception)exception);
    }

    protected String unwrapException(Throwable t) {
        StringBuffer sb = new StringBuffer();
        this.doUnwrapException(sb, t);
        return sb.toString();
    }

    private void doUnwrapException(StringBuffer sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t.toString());
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            this.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }
}

