/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.projectnessie.api.ContentApi;
import org.projectnessie.api.http.HttpContentApi;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.ContentApiImplWithAuthorization;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
public class RestContentResource
implements HttpContentApi {
    private final ServerConfig config;
    private final VersionStore<Content, CommitMeta, Content.Type> store;
    private final AccessChecker accessChecker;
    @Context
    SecurityContext securityContext;

    public RestContentResource() {
        this(null, null, null);
    }

    @Inject
    public RestContentResource(ServerConfig config, VersionStore<Content, CommitMeta, Content.Type> store, AccessChecker accessChecker) {
        this.config = config;
        this.store = store;
        this.accessChecker = accessChecker;
    }

    private ContentApi resource() {
        return new ContentApiImplWithAuthorization(this.config, this.store, this.accessChecker, this.securityContext == null ? null : this.securityContext.getUserPrincipal());
    }

    public Content getContent(ContentKey key, String ref, String hashOnRef) throws NessieNotFoundException {
        return this.resource().getContent(key, ref, hashOnRef);
    }

    public GetMultipleContentsResponse getMultipleContents(String ref, String hashOnRef, GetMultipleContentsRequest request) throws NessieNotFoundException {
        return this.resource().getMultipleContents(ref, hashOnRef, request);
    }
}

