/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

@Provider
public class InstantParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.equals(Instant.class)) {
            return new InstantParamConverter();
        }
        return null;
    }

    private static final class InstantParamConverter
    implements ParamConverter<Instant> {
        private InstantParamConverter() {
        }

        public Instant fromString(String instant) {
            if (null == instant) {
                return null;
            }
            try {
                return Instant.parse(instant);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException(String.format("'%s' could not be parsed to an Instant in ISO-8601 format", instant), e);
            }
        }

        public String toString(Instant instant) {
            if (instant == null) {
                return null;
            }
            return instant.toString();
        }
    }
}

