/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Throwables;
import java.security.AccessControlException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.rest.BaseExceptionMapper;
import org.projectnessie.versioned.BackendLimitExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class NessieExceptionMapper
extends BaseExceptionMapper<Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieExceptionMapper.class);

    public NessieExceptionMapper() {
        this(null);
    }

    @Inject
    public NessieExceptionMapper(ServerConfig config) {
        super(config);
    }

    public Response toResponse(Exception exception) {
        String message;
        String reason;
        int status;
        if (exception instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)exception;
            Response.Status st = Response.Status.fromStatusCode((int)e.getResponse().getStatus());
            status = st.getStatusCode();
            reason = st.getReasonPhrase();
            message = exception.getMessage();
        } else if (exception instanceof BaseNessieClientServerException) {
            BaseNessieClientServerException e = (BaseNessieClientServerException)exception;
            status = e.getStatus();
            reason = e.getReason();
            message = exception.getMessage();
        } else if (exception instanceof JsonParseException || exception instanceof JsonMappingException || exception instanceof IllegalArgumentException) {
            status = Response.Status.BAD_REQUEST.getStatusCode();
            reason = Response.Status.BAD_REQUEST.getReasonPhrase();
            message = exception.getMessage();
        } else if (exception instanceof BackendLimitExceededException) {
            LOGGER.warn("Backend throttled/refused the request: {}", (Object)exception.toString());
            status = Response.Status.TOO_MANY_REQUESTS.getStatusCode();
            reason = Response.Status.TOO_MANY_REQUESTS.getReasonPhrase();
            message = "Backend store refused to process the request: " + exception.toString();
        } else if (exception instanceof AccessControlException) {
            status = Response.Status.FORBIDDEN.getStatusCode();
            reason = Response.Status.FORBIDDEN.getReasonPhrase();
            message = exception.getMessage();
        } else {
            LOGGER.warn("Unhandled exception returned as HTTP/500 to client", (Throwable)exception);
            status = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
            reason = Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase();
            message = Throwables.getCausalChain((Throwable)exception).stream().map(Throwable::toString).collect(Collectors.joining(", caused by"));
        }
        return this.buildExceptionResponse(status, reason, message, exception);
    }
}

