/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.projectnessie.api.RefLogApi;
import org.projectnessie.api.http.HttpRefLogApi;
import org.projectnessie.api.params.RefLogParams;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.RefLogResponse;
import org.projectnessie.services.authz.AccessChecker;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.RefLogApiImplWithAuthorization;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
public class RestRefLogResource
implements HttpRefLogApi {
    private final ServerConfig config;
    private final VersionStore<Content, CommitMeta, Content.Type> store;
    private final AccessChecker accessChecker;
    @Context
    SecurityContext securityContext;

    public RestRefLogResource() {
        this(null, null, null);
    }

    @Inject
    public RestRefLogResource(ServerConfig config, VersionStore<Content, CommitMeta, Content.Type> store, AccessChecker accessChecker) {
        this.config = config;
        this.store = store;
        this.accessChecker = accessChecker;
    }

    private RefLogApi resource() {
        return new RefLogApiImplWithAuthorization(this.config, this.store, this.accessChecker, this.securityContext == null ? null : this.securityContext.getUserPrincipal());
    }

    public RefLogResponse getRefLog(RefLogParams params) throws NessieNotFoundException {
        return this.resource().getRefLog(params);
    }
}

