/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import java.time.Instant;
import javax.ws.rs.ext.ParamConverter;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.services.rest.InstantParamConverterProvider;

public class InstantParamConverterProviderTest {
    private final ParamConverter<Instant> converter = new InstantParamConverterProvider().getConverter(Instant.class, null, null);

    @Test
    public void testNulls() {
        Assertions.assertThat((Instant)((Instant)this.converter.fromString(null))).isNull();
        Assertions.assertThat((String)this.converter.toString(null)).isNull();
    }

    @Test
    public void testInvalid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.converter.fromString("invalid")).isInstanceOf(IllegalArgumentException.class)).hasMessage("'invalid' could not be parsed to an Instant in ISO-8601 format");
    }

    @Test
    public void testValid() {
        Instant now = Instant.now();
        Assertions.assertThat((Instant)((Instant)this.converter.fromString(now.toString()))).isEqualTo((Object)now);
        Assertions.assertThat((String)this.converter.toString((Object)now)).isEqualTo(now.toString());
    }
}

