/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.http.HttpTreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.api.params.GetReferenceParams;
import org.projectnessie.api.params.ReferencesParams;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Transplant;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.TreeApiImplWithAuthorization;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
public class RestTreeResource
implements HttpTreeApi {
    private final ServerConfig config;
    private final VersionStore<Content, CommitMeta, Content.Type> store;
    private final Authorizer authorizer;
    @Context
    SecurityContext securityContext;

    public RestTreeResource() {
        this(null, null, null);
    }

    @Inject
    public RestTreeResource(ServerConfig config, VersionStore<Content, CommitMeta, Content.Type> store, Authorizer authorizer) {
        this.config = config;
        this.store = store;
        this.authorizer = authorizer;
    }

    private TreeApi resource() {
        return new TreeApiImplWithAuthorization(this.config, this.store, this.authorizer, this.securityContext == null ? null : this.securityContext.getUserPrincipal());
    }

    public ReferencesResponse getAllReferences(ReferencesParams params) {
        return this.resource().getAllReferences(params);
    }

    public Branch getDefaultBranch() throws NessieNotFoundException {
        return this.resource().getDefaultBranch();
    }

    public Reference createReference(String sourceRefName, Reference reference) throws NessieNotFoundException, NessieConflictException {
        return this.resource().createReference(sourceRefName, reference);
    }

    public Reference getReferenceByName(GetReferenceParams params) throws NessieNotFoundException {
        return this.resource().getReferenceByName(params);
    }

    public EntriesResponse getEntries(String refName, EntriesParams params) throws NessieNotFoundException {
        return this.resource().getEntries(refName, params);
    }

    public LogResponse getCommitLog(String ref, CommitLogParams params) throws NessieNotFoundException {
        return this.resource().getCommitLog(ref, params);
    }

    public void assignReference(Reference.ReferenceType referenceType, String referenceName, String oldHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.resource().assignReference(referenceType, referenceName, oldHash, assignTo);
    }

    public void deleteReference(Reference.ReferenceType referenceType, String referenceName, String hash) throws NessieConflictException, NessieNotFoundException {
        this.resource().deleteReference(referenceType, referenceName, hash);
    }

    public void transplantCommitsIntoBranch(String branchName, String hash, String message, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        this.resource().transplantCommitsIntoBranch(branchName, hash, message, transplant);
    }

    public void mergeRefIntoBranch(String branchName, String hash, Merge merge) throws NessieNotFoundException, NessieConflictException {
        this.resource().mergeRefIntoBranch(branchName, hash, merge);
    }

    public Branch commitMultipleOperations(String branchName, String hash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        return this.resource().commitMultipleOperations(branchName, hash, operations);
    }
}

