/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import javax.inject.Inject;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.rest.BaseExceptionMapper;

@Provider
public class ValidationExceptionMapper
extends BaseExceptionMapper<ValidationException> {
    public ValidationExceptionMapper() {
        this(null);
    }

    @Inject
    public ValidationExceptionMapper(ServerConfig config) {
        super(config);
    }

    public Response toResponse(ValidationException exception) {
        return this.buildExceptionResponse(ErrorCode.UNKNOWN, this.unwrapException((Throwable)exception), (Exception)exception);
    }

    protected String unwrapException(Throwable t) {
        StringBuffer sb = new StringBuffer();
        this.doUnwrapException(sb, t);
        return sb.toString();
    }

    private void doUnwrapException(StringBuffer sb, Throwable t) {
        if (t == null) {
            return;
        }
        sb.append(t);
        if (t.getCause() != null && t != t.getCause()) {
            sb.append('[');
            this.doUnwrapException(sb, t.getCause());
            sb.append(']');
        }
    }
}

