/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.projectnessie.api.v1.http.HttpTreeApi;
import org.projectnessie.api.v1.params.CommitLogParams;
import org.projectnessie.api.v1.params.EntriesParams;
import org.projectnessie.api.v1.params.GetReferenceParams;
import org.projectnessie.api.v1.params.Merge;
import org.projectnessie.api.v1.params.ReferencesParams;
import org.projectnessie.api.v1.params.Transplant;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.services.authz.Authorizer;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.impl.TreeApiImplWithAuthorization;
import org.projectnessie.services.spi.TreeService;
import org.projectnessie.versioned.VersionStore;

@RequestScoped
@Path(value="v1/trees")
public class RestTreeResource
implements HttpTreeApi {
    private final ServerConfig config;
    private final VersionStore store;
    private final Authorizer authorizer;
    @Context
    SecurityContext securityContext;

    public RestTreeResource() {
        this(null, null, null);
    }

    @Inject
    public RestTreeResource(ServerConfig config, VersionStore store, Authorizer authorizer) {
        this.config = config;
        this.store = store;
        this.authorizer = authorizer;
    }

    private TreeService resource() {
        return new TreeApiImplWithAuthorization(this.config, this.store, this.authorizer, this.securityContext == null ? null : this.securityContext.getUserPrincipal());
    }

    public ReferencesResponse getAllReferences(ReferencesParams params) {
        Preconditions.checkArgument((params.pageToken() == null ? 1 : 0) != 0, (Object)"Paging not supported");
        return this.resource().getAllReferences(params.fetchOption(), params.filter());
    }

    public Branch getDefaultBranch() throws NessieNotFoundException {
        return this.resource().getDefaultBranch();
    }

    public Reference createReference(String sourceRefName, Reference reference) throws NessieNotFoundException, NessieConflictException {
        return this.resource().createReference(reference.getName(), reference.getType(), reference.getHash(), sourceRefName);
    }

    public Reference getReferenceByName(GetReferenceParams params) throws NessieNotFoundException {
        return this.resource().getReferenceByName(params.getRefName(), params.fetchOption());
    }

    public EntriesResponse getEntries(String refName, EntriesParams params) throws NessieNotFoundException {
        Preconditions.checkArgument((params.pageToken() == null ? 1 : 0) != 0, (Object)"Paging not supported");
        return this.resource().getEntries(refName, params.hashOnRef(), params.namespaceDepth(), params.filter());
    }

    public LogResponse getCommitLog(String ref, CommitLogParams params) throws NessieNotFoundException {
        return this.resource().getCommitLog(ref, params.fetchOption(), params.startHash(), params.endHash(), params.filter(), params.maxRecords(), params.pageToken());
    }

    public void assignReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.resource().assignReference(referenceType, referenceName, expectedHash, assignTo);
    }

    public void deleteReference(Reference.ReferenceType referenceType, String referenceName, String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.resource().deleteReference(referenceType, referenceName, expectedHash);
    }

    public MergeResponse transplantCommitsIntoBranch(String branchName, String expectedHash, String message, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        return this.resource().transplantCommitsIntoBranch(branchName, expectedHash, message, transplant.getHashesToTransplant(), transplant.getFromRefName(), transplant.keepIndividualCommits(), (Collection)transplant.getKeyMergeModes(), transplant.getDefaultKeyMergeMode(), transplant.isDryRun(), transplant.isFetchAdditionalInfo(), transplant.isReturnConflictAsResult());
    }

    public MergeResponse mergeRefIntoBranch(String branchName, String expectedHash, Merge merge) throws NessieNotFoundException, NessieConflictException {
        return this.resource().mergeRefIntoBranch(branchName, expectedHash, merge.getFromRefName(), merge.getFromHash(), merge.keepIndividualCommits(), (Collection)merge.getKeyMergeModes(), merge.getDefaultKeyMergeMode(), merge.isDryRun(), merge.isFetchAdditionalInfo(), merge.isReturnConflictAsResult());
    }

    public Branch commitMultipleOperations(String branchName, String expectedHash, Operations operations) throws NessieNotFoundException, NessieConflictException {
        return this.resource().commitMultipleOperations(branchName, expectedHash, operations);
    }
}

