/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Throwables;
import java.security.AccessControlException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.rest.BaseExceptionMapper;
import org.projectnessie.versioned.BackendLimitExceededException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class NessieExceptionMapper
extends BaseExceptionMapper<Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieExceptionMapper.class);

    public NessieExceptionMapper() {
        this(null);
    }

    @Inject
    public NessieExceptionMapper(ServerConfig config) {
        super(config);
    }

    public Response toResponse(Exception exception) {
        String message;
        ErrorCode errorCode;
        if (exception instanceof BaseNessieClientServerException) {
            BaseNessieClientServerException e = (BaseNessieClientServerException)exception;
            errorCode = e.getErrorCode();
            message = exception.getMessage();
        } else if (exception.getCause() instanceof BaseNessieClientServerException) {
            BaseNessieClientServerException e = (BaseNessieClientServerException)exception.getCause();
            errorCode = e.getErrorCode();
            message = exception.getCause().getMessage();
        } else if (exception instanceof JsonParseException || exception instanceof JsonMappingException || exception instanceof IllegalArgumentException) {
            errorCode = ErrorCode.BAD_REQUEST;
            message = exception.getMessage();
        } else if (exception instanceof BackendLimitExceededException) {
            LOGGER.warn("Backend throttled/refused the request: {}", (Object)exception.toString());
            errorCode = ErrorCode.TOO_MANY_REQUESTS;
            message = "Backend store refused to process the request: " + exception;
        } else if (exception instanceof AccessControlException) {
            errorCode = ErrorCode.FORBIDDEN;
            message = exception.getMessage();
        } else if (exception instanceof NotSupportedException) {
            errorCode = ErrorCode.UNSUPPORTED_MEDIA_TYPE;
            message = exception.getMessage();
        } else {
            LOGGER.warn("Unhandled exception returned as HTTP/500 to client", (Throwable)exception);
            errorCode = ErrorCode.UNKNOWN;
            message = Throwables.getCausalChain((Throwable)exception).stream().map(Throwable::toString).collect(Collectors.joining(", caused by"));
        }
        return this.buildExceptionResponse(errorCode, message, exception);
    }
}

