/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.rest;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import org.projectnessie.api.v2.http.HttpTreeApi;
import org.projectnessie.api.v2.params.CommitLogParams;
import org.projectnessie.api.v2.params.DiffParams;
import org.projectnessie.api.v2.params.EntriesParams;
import org.projectnessie.api.v2.params.GetReferenceParams;
import org.projectnessie.api.v2.params.Merge;
import org.projectnessie.api.v2.params.ReferenceResolver;
import org.projectnessie.api.v2.params.ReferencesParams;
import org.projectnessie.api.v2.params.Transplant;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ContentResponse;
import org.projectnessie.model.DiffResponse;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetMultipleContentsRequest;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.ImmutableDiffResponse;
import org.projectnessie.model.ImmutableEntriesResponse;
import org.projectnessie.model.ImmutableGetMultipleContentsRequest;
import org.projectnessie.model.ImmutableLogResponse;
import org.projectnessie.model.ImmutableReferencesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.SingleReferenceResponse;
import org.projectnessie.model.Tag;
import org.projectnessie.model.ser.Views;
import org.projectnessie.services.impl.RefUtil;
import org.projectnessie.services.spi.ConfigService;
import org.projectnessie.services.spi.ContentService;
import org.projectnessie.services.spi.DiffService;
import org.projectnessie.services.spi.PagedCountingResponseHandler;
import org.projectnessie.services.spi.PagedResponseHandler;
import org.projectnessie.services.spi.TreeService;
import org.projectnessie.versioned.WithHash;

@RequestScoped
@jakarta.enterprise.context.RequestScoped
public class RestV2TreeResource
implements HttpTreeApi {
    private final ConfigService configService;
    private final TreeService treeService;
    private final ContentService contentService;
    private final DiffService diffService;

    public RestV2TreeResource() {
        this(null, null, null, null);
    }

    @javax.inject.Inject
    @Inject
    public RestV2TreeResource(ConfigService configService, TreeService treeService, ContentService contentService, DiffService diffService) {
        this.configService = configService;
        this.treeService = treeService;
        this.contentService = contentService;
        this.diffService = diffService;
    }

    private Reference resolveRef(String refPathString) {
        return ReferenceResolver.resolveReferencePathElement((String)refPathString, () -> ((ConfigService)this.configService).getConfig());
    }

    private TreeService tree() {
        return this.treeService;
    }

    private DiffService diff() {
        return this.diffService;
    }

    private ContentService content() {
        return this.contentService;
    }

    @JsonView(value={Views.V2.class})
    public ReferencesResponse getAllReferences(ReferencesParams params) {
        Integer maxRecords = params.maxRecords();
        return (ReferencesResponse)this.tree().getAllReferences(params.fetchOption(), params.filter(), params.pageToken(), (PagedResponseHandler)new PagedCountingResponseHandler<ReferencesResponse, Reference>(maxRecords){
            final ImmutableReferencesResponse.Builder builder;
            {
                this.builder = ReferencesResponse.builder();
            }

            public ReferencesResponse build() {
                return this.builder.build();
            }

            protected boolean doAddEntry(Reference entry) {
                this.builder.addReferences(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                this.builder.isHasMore(true).token(pagingToken);
            }
        });
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse createReference(String name, Reference.ReferenceType type, Reference reference) throws NessieNotFoundException, NessieConflictException {
        String fromRefName = null;
        String fromHash = null;
        if (reference != null) {
            fromRefName = reference.getName();
            fromHash = reference.getHash();
        }
        Reference created = this.tree().createReference(name, type, fromHash, fromRefName);
        return SingleReferenceResponse.builder().reference(created).build();
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse getReferenceByName(GetReferenceParams params) throws NessieNotFoundException {
        Reference reference = this.resolveRef(params.getRef());
        return SingleReferenceResponse.builder().reference(this.tree().getReferenceByName(reference.getName(), params.fetchOption())).build();
    }

    @JsonView(value={Views.V2.class})
    public EntriesResponse getEntries(String ref, EntriesParams params) throws NessieNotFoundException {
        Reference reference = this.resolveRef(ref);
        Integer maxRecords = params.maxRecords();
        ImmutableEntriesResponse.Builder builder = EntriesResponse.builder();
        return (EntriesResponse)this.tree().getEntries(reference.getName(), reference.getHash(), null, params.filter(), params.pageToken(), params.withContent(), (PagedResponseHandler)new PagedCountingResponseHandler<EntriesResponse, EntriesResponse.Entry>(maxRecords){

            public EntriesResponse build() {
                return builder.build();
            }

            protected boolean doAddEntry(EntriesResponse.Entry entry) {
                builder.addEntries(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                builder.isHasMore(true).token(pagingToken);
            }
        }, h -> builder.effectiveReference(RefUtil.toReference((WithHash)h)));
    }

    @JsonView(value={Views.V2.class})
    public LogResponse getCommitLog(String ref, CommitLogParams params) throws NessieNotFoundException {
        Reference reference = this.resolveRef(ref);
        Integer maxRecords = params.maxRecords();
        return (LogResponse)this.tree().getCommitLog(reference.getName(), params.fetchOption(), params.startHash(), reference.getHash(), params.filter(), params.pageToken(), (PagedResponseHandler)new PagedCountingResponseHandler<LogResponse, LogResponse.LogEntry>(maxRecords, 250){
            final ImmutableLogResponse.Builder builder;
            {
                this.builder = ImmutableLogResponse.builder();
            }

            public LogResponse build() {
                return this.builder.build();
            }

            protected boolean doAddEntry(LogResponse.LogEntry entry) {
                this.builder.addLogEntries(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                this.builder.isHasMore(true).token(pagingToken);
            }
        });
    }

    @JsonView(value={Views.V2.class})
    public DiffResponse getDiff(DiffParams params) throws NessieNotFoundException {
        Integer maxRecords = params.maxRecords();
        Reference from = this.resolveRef(params.getFromRef());
        Reference to = this.resolveRef(params.getToRef());
        ImmutableDiffResponse.Builder builder = DiffResponse.builder();
        return (DiffResponse)this.diff().getDiff(from.getName(), from.getHash(), to.getName(), to.getHash(), params.pageToken(), (PagedResponseHandler)new PagedCountingResponseHandler<DiffResponse, DiffResponse.DiffEntry>(maxRecords){

            public DiffResponse build() {
                return builder.build();
            }

            protected boolean doAddEntry(DiffResponse.DiffEntry entry) {
                builder.addDiffs(entry);
                return true;
            }

            public void hasMore(String pagingToken) {
                builder.isHasMore(true).token(pagingToken);
            }
        }, h -> builder.effectiveFromReference(RefUtil.toReference((WithHash)h)), h -> builder.effectiveToReference(RefUtil.toReference((WithHash)h)));
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse assignReference(Reference.ReferenceType type, String ref, Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        Reference reference = ReferenceResolver.resolveReferencePathElement((String)ref, (Reference.ReferenceType)type);
        Reference updated = this.tree().assignReference(type, reference.getName(), reference.getHash(), assignTo);
        return SingleReferenceResponse.builder().reference(updated).build();
    }

    @JsonView(value={Views.V2.class})
    public SingleReferenceResponse deleteReference(Reference.ReferenceType type, String ref) throws NessieConflictException, NessieNotFoundException {
        Reference reference = ReferenceResolver.resolveReferencePathElement((String)ref, (Reference.ReferenceType)type);
        String hash = this.tree().deleteReference(type, reference.getName(), reference.getHash());
        if (reference instanceof Branch) {
            reference = Branch.of((String)reference.getName(), (String)hash);
        }
        if (reference instanceof Tag) {
            reference = Tag.of((String)reference.getName(), (String)hash);
        }
        return SingleReferenceResponse.builder().reference(reference).build();
    }

    @JsonView(value={Views.V2.class})
    public ContentResponse getContent(ContentKey key, String ref) throws NessieNotFoundException {
        Reference reference = this.resolveRef(ref);
        return this.content().getContent(key, reference.getName(), reference.getHash());
    }

    @JsonView(value={Views.V2.class})
    public GetMultipleContentsResponse getSeveralContents(String ref, List<String> keys) throws NessieNotFoundException {
        ImmutableGetMultipleContentsRequest.Builder request = GetMultipleContentsRequest.builder();
        keys.forEach(k -> request.addRequestedKeys(ContentKey.fromPathString((String)k)));
        return this.getMultipleContents(ref, (GetMultipleContentsRequest)request.build());
    }

    @JsonView(value={Views.V2.class})
    public GetMultipleContentsResponse getMultipleContents(String ref, GetMultipleContentsRequest request) throws NessieNotFoundException {
        Reference reference = this.resolveRef(ref);
        return this.content().getMultipleContents(reference.getName(), reference.getHash(), request.getRequestedKeys());
    }

    @JsonView(value={Views.V2.class})
    public MergeResponse transplantCommitsIntoBranch(String branch, Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        Reference ref = this.resolveRef(branch);
        return this.tree().transplantCommitsIntoBranch(ref.getName(), ref.getHash(), transplant.getMessage(), transplant.getHashesToTransplant(), transplant.getFromRefName(), Boolean.valueOf(true), (Collection)transplant.getKeyMergeModes(), transplant.getDefaultKeyMergeMode(), transplant.isDryRun(), transplant.isFetchAdditionalInfo(), transplant.isReturnConflictAsResult());
    }

    @JsonView(value={Views.V2.class})
    public MergeResponse mergeRefIntoBranch(String branch, Merge merge) throws NessieNotFoundException, NessieConflictException {
        Reference ref = this.resolveRef(branch);
        return this.tree().mergeRefIntoBranch(ref.getName(), ref.getHash(), merge.getFromRefName(), merge.getFromHash(), Boolean.valueOf(false), merge.getMessage(), (Collection)merge.getKeyMergeModes(), merge.getDefaultKeyMergeMode(), merge.isDryRun(), merge.isFetchAdditionalInfo(), merge.isReturnConflictAsResult());
    }

    @JsonView(value={Views.V2.class})
    public CommitResponse commitMultipleOperations(String branch, Operations operations) throws NessieNotFoundException, NessieConflictException {
        Reference ref = this.resolveRef(branch);
        return this.tree().commitMultipleOperations(ref.getName(), ref.getHash(), operations);
    }
}

