/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.restjakarta;

import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.services.restjakarta.BaseExceptionMapper;

@Provider
public class ConstraintViolationExceptionMapper
extends BaseExceptionMapper<ConstraintViolationException> {
    public ConstraintViolationExceptionMapper() {
        this(null);
    }

    @Inject
    public ConstraintViolationExceptionMapper(ServerConfig config) {
        super(config);
    }

    public Response toResponse(ConstraintViolationException exception) {
        ErrorCode errorCode = ErrorCode.BAD_REQUEST;
        for (ConstraintViolation violation : exception.getConstraintViolations()) {
            for (Path.Node node : violation.getPropertyPath()) {
                if (ElementKind.RETURN_VALUE != node.getKind()) continue;
                errorCode = ErrorCode.UNKNOWN;
            }
        }
        ConstraintViolationException canonical = new ConstraintViolationException(exception.getConstraintViolations());
        return this.buildExceptionResponse(errorCode, canonical.getMessage(), (Exception)exception, false, header -> {});
    }
}

