/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.services.restjavax;

import com.google.common.base.Throwables;
import java.util.function.Consumer;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.services.config.ServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseExceptionMapper<T extends Throwable>
implements ExceptionMapper<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseExceptionMapper.class);
    private final ServerConfig serverConfig;

    protected BaseExceptionMapper(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    protected Response buildBadRequestResponse(Exception e) {
        return this.buildExceptionResponse(ErrorCode.BAD_REQUEST, e.getMessage(), e);
    }

    protected Response buildExceptionResponse(ErrorCode errorCode, String message, Exception e) {
        return this.buildExceptionResponse(errorCode, message, e, this.serverConfig.sendStacktraceToClient(), h -> {});
    }

    protected Response buildExceptionResponse(ErrorCode errorCode, String message, Exception e, boolean includeExceptionStackTrace, Consumer<Response.ResponseBuilder> responseHandler) {
        String stack = includeExceptionStackTrace ? Throwables.getStackTraceAsString((Throwable)e) : null;
        Response.Status status = Response.Status.fromStatusCode((int)errorCode.httpStatus());
        if (status == null) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        if (message == null) {
            message = "";
        }
        ImmutableNessieError error = ImmutableNessieError.builder().message(message).status(status.getStatusCode()).errorCode(errorCode).reason(status.getReasonPhrase()).serverStackTrace(stack).build();
        LOGGER.debug("Failure on server, propagated to client. Status: {} {}, Message: {}.", new Object[]{status.getStatusCode(), status.getReasonPhrase(), message, e});
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)status).entity((Object)error).type(MediaType.APPLICATION_JSON_TYPE);
        responseHandler.accept(responseBuilder);
        return responseBuilder.build();
    }
}

