/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.minio;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.minio.MinioAccess;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.Base58;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

final class MinioContainer
extends GenericContainer<MinioContainer>
implements MinioAccess,
ExtensionContext.Store.CloseableResource {
    private static final int DEFAULT_PORT = 9000;
    private static final String DEFAULT_IMAGE = "quay.io/minio/minio";
    private static final String DEFAULT_TAG = "latest";
    private static final String MINIO_ACCESS_KEY = "MINIO_ROOT_USER";
    private static final String MINIO_SECRET_KEY = "MINIO_ROOT_PASSWORD";
    private static final String MINIO_DOMAIN = "MINIO_DOMAIN";
    private static final String DEFAULT_STORAGE_DIRECTORY = "/data";
    private static final String HEALTH_ENDPOINT = "/minio/health/ready";
    private final String accessKey;
    private final String secretKey;
    private final String bucket;
    private String hostPort;
    private String s3endpoint;
    private S3Client s3;
    private URI bucketBaseUri;

    public MinioContainer() {
        this(null, null, null, null);
    }

    public MinioContainer(String image, String accessKey, String secretKey, String bucket) {
        super(image == null ? "quay.io/minio/minio:latest" : image);
        this.withNetworkAliases(new String[]{MinioContainer.randomString("minio")});
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(MinioContainer.class)));
        this.addExposedPort(9000);
        this.accessKey = accessKey != null ? accessKey : MinioContainer.randomString("access");
        this.secretKey = secretKey != null ? secretKey : MinioContainer.randomString("secret");
        this.bucket = bucket != null ? bucket : MinioContainer.randomString("bucket");
        this.withEnv(MINIO_ACCESS_KEY, this.accessKey);
        this.withEnv(MINIO_SECRET_KEY, this.secretKey);
        this.withEnv(MINIO_DOMAIN, "localhost");
        this.withCommand(new String[]{"server", DEFAULT_STORAGE_DIRECTORY});
        this.setWaitStrategy(new HttpWaitStrategy().forPort(9000).forPath(HEALTH_ENDPOINT).withStartupTimeout(Duration.ofMinutes(2L)));
    }

    private static String randomString(String prefix) {
        return prefix + "-" + Base58.randomString((int)6).toLowerCase(Locale.ROOT);
    }

    @Override
    public String hostPort() {
        Preconditions.checkState((this.hostPort != null ? 1 : 0) != 0, (Object)"Container not yet started");
        return this.hostPort;
    }

    @Override
    public String accessKey() {
        return this.accessKey;
    }

    @Override
    public String secretKey() {
        return this.secretKey;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public String s3endpoint() {
        Preconditions.checkState((this.s3endpoint != null ? 1 : 0) != 0, (Object)"Container not yet started");
        return this.s3endpoint;
    }

    @Override
    public S3Client s3Client() {
        Preconditions.checkState((this.s3 != null ? 1 : 0) != 0, (Object)"Container not yet started");
        return this.s3;
    }

    @Override
    public Map<String, String> icebergProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("s3.access-key-id", this.accessKey());
        props.put("s3.secret-access-key", this.secretKey());
        props.put("s3.endpoint", this.s3endpoint());
        props.put("http-client.type", "urlconnection");
        return props;
    }

    @Override
    public Configuration hadoopConfiguration() {
        Configuration conf = new Configuration();
        conf.set("fs.s3a.access.key", this.accessKey());
        conf.set("fs.s3a.secret.key", this.secretKey());
        conf.set("fs.s3a.endpoint", this.s3endpoint());
        return conf;
    }

    @Override
    public URI s3BucketUri(String path) {
        Preconditions.checkState((this.bucketBaseUri != null ? 1 : 0) != 0, (Object)"Container not yet started");
        return this.bucketBaseUri.resolve(path);
    }

    public void start() {
        super.start();
        this.hostPort = this.getHost() + ":" + this.getMappedPort(9000);
        this.s3endpoint = String.format("http://%s/", this.hostPort);
        this.bucketBaseUri = URI.create(String.format("s3://%s/", this.bucket()));
        this.s3 = this.createS3Client();
        this.s3.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(this.bucket()).build());
    }

    public void close() {
        this.stop();
    }

    public void stop() {
        try {
            if (this.s3 != null) {
                this.s3.close();
            }
        }
        finally {
            this.s3 = null;
            super.stop();
        }
    }

    private S3Client createS3Client() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).applyMutation(builder -> builder.endpointOverride(URI.create(this.s3endpoint())))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey(), (String)this.secretKey())))).build();
    }
}

