/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.minio;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.projectnessie.minio.Minio;
import org.projectnessie.minio.MinioAccess;
import org.projectnessie.minio.MinioContainer;

public class MinioExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver,
ExecutionCondition {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{MinioExtension.class});

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (OS.current() == OS.LINUX) {
            return ConditionEvaluationResult.enabled((String)"Running on Linux");
        }
        return ConditionEvaluationResult.disabled((String)String.format("Disabled on %s, because neither macOS nor Windows support wildcard localhost FQDNs.", OS.current().name()));
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        AnnotationUtils.findAnnotatedFields((Class)testClass, Minio.class, ReflectionUtils::isStatic).forEach(field -> this.injectField(context, (Field)field));
    }

    public void beforeEach(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        AnnotationUtils.findAnnotatedFields((Class)testClass, Minio.class, ReflectionUtils::isNotStatic).forEach(field -> this.injectField(context, (Field)field));
    }

    private void injectField(ExtensionContext context, Field field) {
        try {
            Minio minio = (Minio)AnnotationUtils.findAnnotation((AnnotatedElement)field, Minio.class).orElseThrow(IllegalStateException::new);
            MinioAccess container = (MinioAccess)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)field.toString(), x -> this.createContainer(minio), MinioAccess.class);
            ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(context.getTestInstance().orElse(null), container);
        }
        catch (Throwable t) {
            ExceptionUtils.throwAsUncheckedException((Throwable)t);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (!parameterContext.findAnnotation(Minio.class).isPresent()) {
            return false;
        }
        return parameterContext.getParameter().getType().isAssignableFrom(MinioAccess.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)(MinioExtension.class.getName() + '#' + parameterContext.getParameter().getName()), k -> {
            Minio minio = (Minio)parameterContext.findAnnotation(Minio.class).get();
            return this.createContainer(minio);
        }, MinioAccess.class);
    }

    private MinioAccess createContainer(Minio minio) {
        String accessKey = MinioExtension.nonDefault(minio.accessKey());
        String secretKey = MinioExtension.nonDefault(minio.secretKey());
        String bucket = MinioExtension.nonDefault(minio.bucket());
        MinioContainer container = (MinioContainer)new MinioContainer(null, accessKey, secretKey, bucket).withStartupAttempts(5);
        container.start();
        return container;
    }

    private static String nonDefault(String s) {
        return s.equals("minio_default_value__") ? null : s;
    }
}

