/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.s3mock.data.Owner;
import org.projectnessie.s3mock.data.S3Object;
import org.projectnessie.s3mock.data.StorageClass;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="S3Object", generator="Immutables")
@Immutable
public final class ImmutableS3Object
implements S3Object {
    private final String key;
    private final String lastModified;
    private final String etag;
    private final String size;
    private final StorageClass storageClass;
    private final Owner owner;

    private ImmutableS3Object(String key, String lastModified, String etag, String size, StorageClass storageClass, Owner owner) {
        this.key = key;
        this.lastModified = lastModified;
        this.etag = etag;
        this.size = size;
        this.storageClass = storageClass;
        this.owner = owner;
    }

    @Override
    @JsonProperty(value="Key")
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="LastModified")
    public String lastModified() {
        return this.lastModified;
    }

    @Override
    @JsonProperty(value="ETag")
    public String etag() {
        return this.etag;
    }

    @Override
    @JsonProperty(value="Size")
    public String size() {
        return this.size;
    }

    @Override
    @JsonProperty(value="StorageClass")
    public StorageClass storageClass() {
        return this.storageClass;
    }

    @Override
    @JsonProperty(value="Owner")
    public Owner owner() {
        return this.owner;
    }

    public final ImmutableS3Object withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableS3Object(newValue, this.lastModified, this.etag, this.size, this.storageClass, this.owner);
    }

    public final ImmutableS3Object withLastModified(String value) {
        String newValue = Objects.requireNonNull(value, "lastModified");
        if (this.lastModified.equals(newValue)) {
            return this;
        }
        return new ImmutableS3Object(this.key, newValue, this.etag, this.size, this.storageClass, this.owner);
    }

    public final ImmutableS3Object withEtag(String value) {
        String newValue = Objects.requireNonNull(value, "etag");
        if (this.etag.equals(newValue)) {
            return this;
        }
        return new ImmutableS3Object(this.key, this.lastModified, newValue, this.size, this.storageClass, this.owner);
    }

    public final ImmutableS3Object withSize(String value) {
        String newValue = Objects.requireNonNull(value, "size");
        if (this.size.equals(newValue)) {
            return this;
        }
        return new ImmutableS3Object(this.key, this.lastModified, this.etag, newValue, this.storageClass, this.owner);
    }

    public final ImmutableS3Object withStorageClass(StorageClass value) {
        StorageClass newValue = Objects.requireNonNull(value, "storageClass");
        if (this.storageClass == newValue) {
            return this;
        }
        return new ImmutableS3Object(this.key, this.lastModified, this.etag, this.size, newValue, this.owner);
    }

    public final ImmutableS3Object withOwner(Owner value) {
        if (this.owner == value) {
            return this;
        }
        Owner newValue = Objects.requireNonNull(value, "owner");
        return new ImmutableS3Object(this.key, this.lastModified, this.etag, this.size, this.storageClass, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableS3Object && this.equalTo(0, (ImmutableS3Object)another);
    }

    private boolean equalTo(int synthetic, ImmutableS3Object another) {
        return this.key.equals(another.key) && this.lastModified.equals(another.lastModified) && this.etag.equals(another.etag) && this.size.equals(another.size) && this.storageClass.equals((Object)another.storageClass) && this.owner.equals(another.owner);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.lastModified.hashCode();
        h += (h << 5) + this.etag.hashCode();
        h += (h << 5) + this.size.hashCode();
        h += (h << 5) + this.storageClass.hashCode();
        h += (h << 5) + this.owner.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"S3Object").omitNullValues().add("key", (Object)this.key).add("lastModified", (Object)this.lastModified).add("etag", (Object)this.etag).add("size", (Object)this.size).add("storageClass", (Object)this.storageClass).add("owner", (Object)this.owner).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableS3Object fromJson(Json json) {
        Builder builder = ImmutableS3Object.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.lastModified != null) {
            builder.lastModified(json.lastModified);
        }
        if (json.etag != null) {
            builder.etag(json.etag);
        }
        if (json.size != null) {
            builder.size(json.size);
        }
        if (json.storageClass != null) {
            builder.storageClass(json.storageClass);
        }
        if (json.owner != null) {
            builder.owner(json.owner);
        }
        return builder.build();
    }

    public static ImmutableS3Object copyOf(S3Object instance) {
        if (instance instanceof ImmutableS3Object) {
            return (ImmutableS3Object)instance;
        }
        return ImmutableS3Object.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="S3Object", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_LAST_MODIFIED = 2L;
        private static final long INIT_BIT_ETAG = 4L;
        private static final long INIT_BIT_SIZE = 8L;
        private static final long INIT_BIT_STORAGE_CLASS = 16L;
        private static final long INIT_BIT_OWNER = 32L;
        private long initBits = 63L;
        @Nullable
        private String key;
        @Nullable
        private String lastModified;
        @Nullable
        private String etag;
        @Nullable
        private String size;
        @Nullable
        private StorageClass storageClass;
        @Nullable
        private Owner owner;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(S3Object instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.lastModified(instance.lastModified());
            this.etag(instance.etag());
            this.size(instance.size());
            this.storageClass(instance.storageClass());
            this.owner(instance.owner());
            return this;
        }

        @JsonProperty(value="Key")
        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="LastModified")
        @CanIgnoreReturnValue
        public final Builder lastModified(String lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="ETag")
        @CanIgnoreReturnValue
        public final Builder etag(String etag) {
            this.etag = Objects.requireNonNull(etag, "etag");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Size")
        @CanIgnoreReturnValue
        public final Builder size(String size) {
            this.size = Objects.requireNonNull(size, "size");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="StorageClass")
        @CanIgnoreReturnValue
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass = Objects.requireNonNull(storageClass, "storageClass");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="Owner")
        @CanIgnoreReturnValue
        public final Builder owner(Owner owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableS3Object build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableS3Object(this.key, this.lastModified, this.etag, this.size, this.storageClass, this.owner);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lastModified");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("etag");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("size");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("storageClass");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("owner");
            }
            return "Cannot build S3Object, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="S3Object", generator="Immutables")
    static final class Json
    implements S3Object {
        @Nullable
        String key;
        @Nullable
        String lastModified;
        @Nullable
        String etag;
        @Nullable
        String size;
        @Nullable
        StorageClass storageClass;
        @Nullable
        Owner owner;

        Json() {
        }

        @JsonProperty(value="Key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="LastModified")
        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @JsonProperty(value="ETag")
        public void setEtag(String etag) {
            this.etag = etag;
        }

        @JsonProperty(value="Size")
        public void setSize(String size) {
            this.size = size;
        }

        @JsonProperty(value="StorageClass")
        public void setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
        }

        @JsonProperty(value="Owner")
        public void setOwner(Owner owner) {
            this.owner = owner;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String lastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String etag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StorageClass storageClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Owner owner() {
            throw new UnsupportedOperationException();
        }
    }
}

