/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock;

import com.fasterxml.jackson.jaxrs.xml.JacksonXMLProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.immutables.value.Value;
import org.projectnessie.s3mock.ImmutableIcebergS3Mock;
import org.projectnessie.s3mock.S3Bucket;
import org.projectnessie.s3mock.S3Resource;

@Value.Immutable
public abstract class IcebergS3Mock {
    @Value.Default
    public String initAddress() {
        return "127.0.0.1";
    }

    public static ImmutableIcebergS3Mock.Builder builder() {
        return ImmutableIcebergS3Mock.builder();
    }

    public abstract Map<String, S3Bucket> buckets();

    public S3MockServer start() {
        ResourceConfig config = new ResourceConfig();
        config.register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(IcebergS3Mock.this).to(IcebergS3Mock.class);
            }
        });
        config.register(JacksonXMLProvider.class);
        config.register(S3Resource.class);
        URI initUri = URI.create(String.format("http://%s:0/", this.initAddress()));
        return new MockServer(initUri, config);
    }

    private static final class MockServer
    implements S3MockServer {
        private final Server server;
        private final URI baseUri;

        public MockServer(URI initUri, ResourceConfig config) {
            this.server = JettyHttpContainerFactory.createServer((URI)initUri, (ResourceConfig)config, (boolean)true);
            this.baseUri = MockServer.baseUri(this.server, initUri);
        }

        private static URI baseUri(Server server, URI initUri) {
            for (Connector connector : server.getConnectors()) {
                if (!(connector instanceof ServerConnector)) continue;
                ServerConnector sc = (ServerConnector)connector;
                int localPort = sc.getLocalPort();
                try {
                    return new URI(initUri.getScheme(), initUri.getUserInfo(), initUri.getHost(), localPort, initUri.getPath(), null, null);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException("Server has no connectors");
        }

        @Override
        public URI getBaseUri() {
            return this.baseUri;
        }

        @Override
        public void close() throws Exception {
            if (this.server != null) {
                this.server.stop();
            }
        }
    }

    public static interface S3MockServer
    extends AutoCloseable {
        public URI getBaseUri();

        default public Map<String, String> icebergProperties() {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("s3.access-key-id", "accessKey");
            props.put("s3.secret-access-key", "secretKey");
            props.put("s3.endpoint", this.getBaseUri().toString());
            props.put("http-client.type", "urlconnection");
            return props;
        }
    }
}

