/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.s3mock.IcebergS3Mock;
import org.projectnessie.s3mock.S3Bucket;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IcebergS3Mock", generator="Immutables")
@Immutable
public final class ImmutableIcebergS3Mock
extends IcebergS3Mock {
    private final String initAddress;
    private final ImmutableMap<String, S3Bucket> buckets;

    private ImmutableIcebergS3Mock(Builder builder) {
        this.buckets = builder.buckets.build();
        this.initAddress = builder.initAddress != null ? builder.initAddress : Objects.requireNonNull(super.initAddress(), "initAddress");
    }

    private ImmutableIcebergS3Mock(String initAddress, ImmutableMap<String, S3Bucket> buckets) {
        this.initAddress = initAddress;
        this.buckets = buckets;
    }

    @Override
    public String initAddress() {
        return this.initAddress;
    }

    public ImmutableMap<String, S3Bucket> buckets() {
        return this.buckets;
    }

    public final ImmutableIcebergS3Mock withInitAddress(String value) {
        String newValue = Objects.requireNonNull(value, "initAddress");
        if (this.initAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergS3Mock(newValue, this.buckets);
    }

    public final ImmutableIcebergS3Mock withBuckets(Map<String, ? extends S3Bucket> entries) {
        if (this.buckets == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableIcebergS3Mock(this.initAddress, (ImmutableMap<String, S3Bucket>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIcebergS3Mock && this.equalTo(0, (ImmutableIcebergS3Mock)another);
    }

    private boolean equalTo(int synthetic, ImmutableIcebergS3Mock another) {
        return this.initAddress.equals(another.initAddress) && this.buckets.equals(another.buckets);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.initAddress.hashCode();
        h += (h << 5) + this.buckets.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IcebergS3Mock").omitNullValues().add("initAddress", (Object)this.initAddress).add("buckets", this.buckets).toString();
    }

    public static ImmutableIcebergS3Mock copyOf(IcebergS3Mock instance) {
        if (instance instanceof ImmutableIcebergS3Mock) {
            return (ImmutableIcebergS3Mock)instance;
        }
        return ImmutableIcebergS3Mock.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IcebergS3Mock", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String initAddress;
        private ImmutableMap.Builder<String, S3Bucket> buckets = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IcebergS3Mock instance) {
            Objects.requireNonNull(instance, "instance");
            this.initAddress(instance.initAddress());
            this.putAllBuckets(instance.buckets());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initAddress(String initAddress) {
            this.initAddress = Objects.requireNonNull(initAddress, "initAddress");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBuckets(String key, S3Bucket value) {
            this.buckets.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBuckets(Map.Entry<String, ? extends S3Bucket> entry) {
            this.buckets.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder buckets(Map<String, ? extends S3Bucket> entries) {
            this.buckets = ImmutableMap.builder();
            return this.putAllBuckets(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllBuckets(Map<String, ? extends S3Bucket> entries) {
            this.buckets.putAll(entries);
            return this;
        }

        public ImmutableIcebergS3Mock build() {
            return new ImmutableIcebergS3Mock(this);
        }
    }
}

