/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.projectnessie.s3mock.IcebergS3Mock;
import org.projectnessie.s3mock.MockObject;
import org.projectnessie.s3mock.S3Bucket;
import org.projectnessie.s3mock.data.BatchDeleteRequest;
import org.projectnessie.s3mock.data.Bucket;
import org.projectnessie.s3mock.data.DeletedS3Object;
import org.projectnessie.s3mock.data.ErrorObj;
import org.projectnessie.s3mock.data.ErrorResponse;
import org.projectnessie.s3mock.data.ImmutableBatchDeleteResponse;
import org.projectnessie.s3mock.data.ImmutableBucket;
import org.projectnessie.s3mock.data.ImmutableBuckets;
import org.projectnessie.s3mock.data.ImmutableDeletedS3Object;
import org.projectnessie.s3mock.data.ImmutableErrorObj;
import org.projectnessie.s3mock.data.ImmutableListAllMyBucketsResult;
import org.projectnessie.s3mock.data.ImmutableS3Object;
import org.projectnessie.s3mock.data.ListAllMyBucketsResult;
import org.projectnessie.s3mock.data.ListBucketResult;
import org.projectnessie.s3mock.data.ListBucketResultBase;
import org.projectnessie.s3mock.data.ListBucketResultV2;
import org.projectnessie.s3mock.data.Owner;
import org.projectnessie.s3mock.data.Prefix;
import org.projectnessie.s3mock.data.Range;
import org.projectnessie.s3mock.data.S3Object;
import org.projectnessie.s3mock.data.S3ObjectIdentifier;
import org.projectnessie.s3mock.util.Holder;
import org.projectnessie.s3mock.util.PrefixSpliterator;
import org.projectnessie.s3mock.util.StartAfterSpliterator;

@Path(value="/")
@Produces(value={"application/xml"})
@Consumes(value={"application/xml"})
public class S3Resource {
    @Inject
    IcebergS3Mock mockServer;
    private static final Owner TEST_OWNER = Owner.of(42L, "nessie-iceberg-s3-mock");

    @Path(value="ready")
    @GET
    @Produces(value={"application/json"})
    public JsonNode ready() {
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.put("ready", true);
        return node;
    }

    @GET
    public ListAllMyBucketsResult listBuckets() {
        ImmutableBuckets.Builder buckets = ImmutableBuckets.builder();
        this.mockServer.buckets().forEach((name, bucket) -> buckets.addBuckets((Bucket)ImmutableBucket.builder().name((String)name).creationDate(bucket.creationDate()).build()));
        return ImmutableListAllMyBucketsResult.builder().owner(TEST_OWNER).buckets(buckets.build()).build();
    }

    @PUT
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response createBucket(@PathParam(value="bucketName") String bucketName) {
        return S3Resource.notImplemented();
    }

    @HEAD
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response headBucket(@PathParam(value="bucketName") String bucketName) {
        return this.withBucket(bucketName, b -> Response.ok().build());
    }

    @DELETE
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response deleteBucket(@PathParam(value="bucketName") String bucketName) {
        return S3Resource.notImplemented();
    }

    @GET
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response listObjectsInsideBucket(@PathParam(value="bucketName") String bucketName, @QueryParam(value="prefix") String prefix, @QueryParam(value="delimiter") @DefaultValue(value="/") String delimiter, @QueryParam(value="marker") String marker, @QueryParam(value="encoding-type") String encodingType, @QueryParam(value="max-keys") @DefaultValue(value="1000") int maxKeys, @QueryParam(value="list-type") @DefaultValue(value="1") int listType, @QueryParam(value="continuation-token") String continuationToken, @QueryParam(value="start-after") String startAfter, @HeaderParam(value="x-amz-request-id") String requestId) {
        return this.withBucket(bucketName, b -> {
            try (Stream<S3Bucket.ListElement> listStream = b.lister().list(prefix);){
                ListBucketResultBase.Builder<ListBucketResult.Builder> base;
                ListBucketResult.Builder v1 = null;
                ListBucketResultV2.Builder v2 = null;
                switch (listType) {
                    case 1: {
                        v1 = ListBucketResult.builder();
                        base = v1;
                        break;
                    }
                    case 2: {
                        v2 = ListBucketResultV2.builder();
                        base = v2;
                        break;
                    }
                    default: {
                        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                        return response;
                    }
                }
                boolean truncated = false;
                String nextMarker = null;
                String nextContinuationToken = null;
                int keyCount = 0;
                HashSet<String> prefixes = new HashSet<String>();
                String lastKey = null;
                Function<String, List> keyElements = key -> Arrays.asList(key.split(delimiter));
                Spliterator<S3Bucket.ListElement> split = listStream.spliterator();
                if (continuationToken != null) {
                    split = new StartAfterSpliterator<S3Bucket.ListElement>(split, e -> e.key().equals(continuationToken));
                } else if (startAfter != null) {
                    split = new StartAfterSpliterator<S3Bucket.ListElement>(split, e -> e.key().compareTo(startAfter) >= 0);
                }
                if (prefix != null && !prefix.isEmpty()) {
                    List prefixElements = keyElements.apply(prefix);
                    Predicate<String> prefixMatch = key -> {
                        List k = (List)keyElements.apply((String)key);
                        return k.size() >= prefixElements.size() && prefixElements.equals(k.subList(0, prefixElements.size()));
                    };
                    split = new PrefixSpliterator<S3Bucket.ListElement>(split, e -> prefixMatch.test(e.key()));
                }
                Holder current = new Holder();
                while (split.tryAdvance(current::set)) {
                    if (keyCount == maxKeys) {
                        truncated = true;
                        nextMarker = lastKey;
                        nextContinuationToken = lastKey;
                        break;
                    }
                    String key2 = ((S3Bucket.ListElement)current.get()).key();
                    List elems = keyElements.apply(key2);
                    String pre = String.join((CharSequence)delimiter, elems.subList(0, elems.size() - 1));
                    MockObject obj = ((S3Bucket.ListElement)current.get()).object();
                    base.addContents((S3Object)ImmutableS3Object.builder().etag(obj.etag()).key(key2).owner(Owner.of(42L, "nobody")).size(Long.toString(obj.contentLength())).lastModified(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(obj.lastModified()), ZoneId.of("UTC")))).storageClass(obj.storageClass()).build());
                    ++keyCount;
                    lastKey = key2;
                    if (!prefixes.add(pre)) continue;
                    base.addCommonPrefixes(Prefix.of(pre));
                }
                base.isTruncated(truncated).encodingType(encodingType).maxKeys(maxKeys).name(bucketName);
                ListBucketResultBase result = null;
                switch (listType) {
                    case 1: {
                        result = v1.marker(marker).nextMarker(nextMarker).build();
                        break;
                    }
                    case 2: {
                        result = v2.keyCount(keyCount).continuationToken(continuationToken).nextContinuationToken(nextContinuationToken).startAfter(startAfter).build();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                Response response = Response.ok((Object)result).build();
                return response;
            }
        });
    }

    @POST
    @Path(value="/{bucketName:[a-z0-9.-]+}")
    public Response batchDeleteObjects(@PathParam(value="bucketName") String bucketName, @QueryParam(value="delete") @Nullable String deleteMarker, @RequestBody BatchDeleteRequest body) {
        return this.withBucket(bucketName, b -> {
            ImmutableBatchDeleteResponse.Builder response = ImmutableBatchDeleteResponse.builder();
            for (S3ObjectIdentifier s3ObjectIdentifier : body.objectsToDelete()) {
                if (b.deleter().delete(s3ObjectIdentifier)) {
                    response.addDeletedObjects((DeletedS3Object)ImmutableDeletedS3Object.builder().key(s3ObjectIdentifier.key()).versionId(s3ObjectIdentifier.versionId()).build());
                    continue;
                }
                response.addErrors((ErrorObj)ImmutableErrorObj.builder().key(s3ObjectIdentifier.key()).versionId(s3ObjectIdentifier.versionId()).code("NoSuchKey").build());
            }
            return Response.ok((Object)response.build()).build();
        });
    }

    @HEAD
    @Path(value="/{bucketName:[a-z0-9.-]+}/{object:.+}")
    public Response headObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName) {
        return this.withBucketObject(bucketName, objectName, obj -> Response.ok().tag(obj.etag()).type(obj.contentType()).header("Content-Length", (Object)Long.toString(obj.contentLength())).lastModified(new Date(obj.lastModified())).build());
    }

    @DELETE
    @Path(value="/{bucketName:[a-z0-9.-]+}/{object:.+}")
    public Response deleteObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName) {
        return this.withBucket(bucketName, b -> {
            b.deleter().delete(S3ObjectIdentifier.of(objectName));
            return S3Resource.noContent();
        });
    }

    @GET
    @Path(value="/{bucketName:[a-z0-9.-]+}/{object:.+}")
    @Produces(value={"*/*"})
    public Response getObject(@PathParam(value="bucketName") String bucketName, @PathParam(value="object") String objectName, @HeaderParam(value="Range") Range range, @HeaderParam(value="If-Match") List<String> match, @HeaderParam(value="If-None-Match") List<String> noneMatch, @HeaderParam(value="If-Modified-Since") Date modifiedSince, @HeaderParam(value="If-Unmodified-Since") Date unmodifiedSince) {
        if (range != null) {
            // empty if block
        }
        return this.withBucketObject(bucketName, objectName, obj -> {
            if (unmodifiedSince != null && unmodifiedSince.getTime() > obj.lastModified()) {
                return S3Resource.preconditionFailed();
            }
            if (modifiedSince != null && modifiedSince.getTime() > obj.lastModified()) {
                return S3Resource.notModified(obj.etag());
            }
            if (!match.isEmpty() && !match.contains(obj.etag())) {
                return S3Resource.preconditionFailed();
            }
            if (!noneMatch.isEmpty() && noneMatch.contains(obj.etag())) {
                return S3Resource.notModified(obj.etag());
            }
            StreamingOutput stream = output -> obj.writer().write(range, output);
            return Response.ok((Object)stream).tag(obj.etag()).type(obj.contentType()).header("Content-Length", (Object)Long.toString(obj.contentLength())).lastModified(new Date(obj.lastModified())).build();
        });
    }

    private static Response preconditionFailed() {
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).type(MediaType.APPLICATION_XML_TYPE).entity((Object)ErrorResponse.of("PreconditionFailed", "Precondition Failed")).build();
    }

    private static Response notModified(String etag) {
        return Response.notModified((String)etag).build();
    }

    private static Response noContent() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private static Response bucketNotFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_XML_TYPE).entity((Object)ErrorResponse.of("NoSuchBucket", "The specified bucket does not exist.")).build();
    }

    private static Response keyNotFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_XML_TYPE).entity((Object)ErrorResponse.of("NoSuchKey", "The specified key does not exist.")).build();
    }

    private static Response notImplemented() {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    private Response withBucket(String bucketName, Function<S3Bucket, Response> worker) {
        S3Bucket bucket = this.mockServer.buckets().get(bucketName);
        if (bucket == null) {
            return S3Resource.bucketNotFound();
        }
        return worker.apply(bucket);
    }

    private Response withBucketObject(String bucketName, String objectName, Function<MockObject, Response> worker) {
        return this.withBucket(bucketName, bucket -> {
            MockObject o = bucket.object().retrieve(objectName);
            if (o == null) {
                return S3Resource.keyNotFound();
            }
            return (Response)worker.apply(o);
        });
    }
}

