/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.s3mock.data.ErrorResponse;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErrorResponse", generator="Immutables")
@Immutable
public final class ImmutableErrorResponse
implements ErrorResponse {
    private final String code;
    private final String message;
    @Nullable
    private final String resource;
    @Nullable
    private final String requestId;

    private ImmutableErrorResponse(String code, String message, @Nullable String resource, @Nullable String requestId) {
        this.code = Objects.requireNonNull(code, "code");
        this.message = Objects.requireNonNull(message, "message");
        this.resource = resource;
        this.requestId = requestId;
    }

    private ImmutableErrorResponse(ImmutableErrorResponse original, String code, String message, @Nullable String resource, @Nullable String requestId) {
        this.code = code;
        this.message = message;
        this.resource = resource;
        this.requestId = requestId;
    }

    @Override
    @JsonProperty(value="Code")
    public String code() {
        return this.code;
    }

    @Override
    @JsonProperty(value="Message")
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty(value="Resource")
    @Nullable
    public String resource() {
        return this.resource;
    }

    @Override
    @JsonProperty(value="RequestId")
    @Nullable
    public String requestId() {
        return this.requestId;
    }

    public final ImmutableErrorResponse withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableErrorResponse(this, newValue, this.message, this.resource, this.requestId);
    }

    public final ImmutableErrorResponse withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableErrorResponse(this, this.code, newValue, this.resource, this.requestId);
    }

    public final ImmutableErrorResponse withResource(@Nullable String value) {
        if (Objects.equals(this.resource, value)) {
            return this;
        }
        return new ImmutableErrorResponse(this, this.code, this.message, value, this.requestId);
    }

    public final ImmutableErrorResponse withRequestId(@Nullable String value) {
        if (Objects.equals(this.requestId, value)) {
            return this;
        }
        return new ImmutableErrorResponse(this, this.code, this.message, this.resource, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorResponse && this.equalTo(0, (ImmutableErrorResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrorResponse another) {
        return this.code.equals(another.code) && this.message.equals(another.message) && Objects.equals(this.resource, another.resource) && Objects.equals(this.requestId, another.requestId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.resource);
        h += (h << 5) + Objects.hashCode(this.requestId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErrorResponse").omitNullValues().add("code", (Object)this.code).add("message", (Object)this.message).add("resource", (Object)this.resource).add("requestId", (Object)this.requestId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorResponse fromJson(Json json) {
        Builder builder = ImmutableErrorResponse.builder();
        if (json.code != null) {
            builder.code(json.code);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.resource != null) {
            builder.resource(json.resource);
        }
        if (json.requestId != null) {
            builder.requestId(json.requestId);
        }
        return builder.build();
    }

    public static ImmutableErrorResponse of(String code, String message, @Nullable String resource, @Nullable String requestId) {
        return new ImmutableErrorResponse(code, message, resource, requestId);
    }

    public static ImmutableErrorResponse copyOf(ErrorResponse instance) {
        if (instance instanceof ImmutableErrorResponse) {
            return (ImmutableErrorResponse)instance;
        }
        return ImmutableErrorResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private String code;
        @Nullable
        private String message;
        @Nullable
        private String resource;
        @Nullable
        private String requestId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ErrorResponse instance) {
            String requestIdValue;
            Objects.requireNonNull(instance, "instance");
            this.code(instance.code());
            this.message(instance.message());
            String resourceValue = instance.resource();
            if (resourceValue != null) {
                this.resource(resourceValue);
            }
            if ((requestIdValue = instance.requestId()) != null) {
                this.requestId(requestIdValue);
            }
            return this;
        }

        @JsonProperty(value="Code")
        @CanIgnoreReturnValue
        public final Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Message")
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Resource")
        @CanIgnoreReturnValue
        public final Builder resource(@Nullable String resource) {
            this.resource = resource;
            return this;
        }

        @JsonProperty(value="RequestId")
        @CanIgnoreReturnValue
        public final Builder requestId(@Nullable String requestId) {
            this.requestId = requestId;
            return this;
        }

        public ImmutableErrorResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorResponse(null, this.code, this.message, this.resource, this.requestId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build ErrorResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ErrorResponse", generator="Immutables")
    static final class Json
    implements ErrorResponse {
        @Nullable
        String code;
        @Nullable
        String message;
        @Nullable
        String resource;
        @Nullable
        String requestId;

        Json() {
        }

        @JsonProperty(value="Code")
        public void setCode(String code) {
            this.code = code;
        }

        @JsonProperty(value="Message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="Resource")
        public void setResource(@Nullable String resource) {
            this.resource = resource;
        }

        @JsonProperty(value="RequestId")
        public void setRequestId(@Nullable String requestId) {
            this.requestId = requestId;
        }

        @Override
        public String code() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String resource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String requestId() {
            throw new UnsupportedOperationException();
        }
    }
}

