/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.s3mock.util;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class PrefixSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<T> matcher;
    private boolean didMatch;
    private boolean exhausted;
    private T value;

    public PrefixSpliterator(Spliterator<T> source, Predicate<T> matcher) {
        super(source.estimateSize(), source.characteristics());
        this.source = source;
        this.matcher = matcher;
    }

    private void set(T value) {
        this.value = value;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean currentMatches;
        do {
            if (this.exhausted) {
                return false;
            }
            if (!this.source.tryAdvance(this::set)) {
                this.exhausted = true;
                return false;
            }
            currentMatches = this.matcher.test(this.value);
            if (currentMatches) {
                action.accept(this.value);
            }
            if (this.didMatch) {
                if (currentMatches) continue;
                this.exhausted = true;
                return false;
            }
            if (!currentMatches) continue;
            this.didMatch = true;
        } while (!currentMatches);
        return true;
    }
}

