/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.SqlView;
import org.projectnessie.server.store.TableCommitMetaStoreWorker;
import org.projectnessie.store.ObjectTypes;

class TestStoreWorker {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String ID = "x";
    private final TableCommitMetaStoreWorker worker = new TableCommitMetaStoreWorker();

    TestStoreWorker() {
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testDeserialization(Map.Entry<ByteString, Contents> entry) {
        Contents actual = this.worker.valueFromStore(entry.getKey(), Optional.empty());
        Assertions.assertEquals((Object)entry.getValue(), (Object)actual);
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testSerialization(Map.Entry<ByteString, Contents> entry) {
        ByteString actual = this.worker.toStoreOnReferenceState(entry.getValue());
        Assertions.assertEquals((Object)entry.getKey(), (Object)actual);
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testSerde(Map.Entry<ByteString, Contents> entry) {
        ByteString actualBytes = this.worker.toStoreOnReferenceState(entry.getValue());
        Assertions.assertEquals((Object)entry.getValue(), (Object)this.worker.valueFromStore(actualBytes, Optional.empty()));
        Contents actualContents = this.worker.valueFromStore(entry.getKey(), Optional.empty());
        Assertions.assertEquals((Object)entry.getKey(), (Object)this.worker.toStoreOnReferenceState(actualContents));
    }

    @Test
    void testSerdeIceberg() {
        String path = "foo/bar";
        IcebergTable table = IcebergTable.of((String)path, (long)42L, (String)ID);
        ObjectTypes.Contents protoTableGlobal = ObjectTypes.Contents.newBuilder().setId(ID).setIcebergTableMetadata(ObjectTypes.IcebergTableMetadata.newBuilder().setMetadataLocation(path).build()).build();
        ObjectTypes.Contents protoSnapshot = ObjectTypes.Contents.newBuilder().setId(ID).setIcebergSnapshot(ObjectTypes.IcebergSnapshot.newBuilder().setSnapshotId(42L).build()).build();
        ByteString tableGlobalBytes = this.worker.toStoreGlobalState((Contents)table);
        ByteString snapshotBytes = this.worker.toStoreOnReferenceState((Contents)table);
        Assertions.assertEquals((Object)protoTableGlobal.toByteString(), (Object)tableGlobalBytes);
        Assertions.assertEquals((Object)protoSnapshot.toByteString(), (Object)snapshotBytes);
        Contents deserialized = this.worker.valueFromStore(snapshotBytes, Optional.of(tableGlobalBytes));
        Assertions.assertEquals((Object)table, (Object)deserialized);
    }

    @Test
    void testCommitSerde() throws JsonProcessingException {
        ImmutableCommitMeta expectedCommit = ImmutableCommitMeta.builder().commitTime(Instant.now()).authorTime(Instant.now()).author("bill").committer("ted").hash("xyz").message("commit msg").build();
        ByteString expectedBytes = ByteString.copyFrom((byte[])MAPPER.writeValueAsBytes((Object)expectedCommit));
        CommitMeta actualCommit = (CommitMeta)this.worker.getMetadataSerializer().fromBytes(expectedBytes);
        Assertions.assertEquals((Object)expectedCommit, (Object)actualCommit);
        ByteString actualBytes = this.worker.getMetadataSerializer().toBytes((Object)expectedCommit);
        Assertions.assertEquals((Object)expectedBytes, (Object)actualBytes);
        actualBytes = this.worker.getMetadataSerializer().toBytes((Object)expectedCommit);
        Assertions.assertEquals((Object)expectedCommit, (Object)this.worker.getMetadataSerializer().fromBytes(actualBytes));
        actualCommit = (CommitMeta)this.worker.getMetadataSerializer().fromBytes(expectedBytes);
        Assertions.assertEquals((Object)expectedBytes, (Object)this.worker.getMetadataSerializer().toBytes((Object)actualCommit));
    }

    private static Stream<Map.Entry<ByteString, Contents>> provideDeserialization() {
        return Stream.of(TestStoreWorker.getDelta(), TestStoreWorker.getView());
    }

    private static Map.Entry<ByteString, Contents> getDelta() {
        String path = "foo/bar";
        String cl1 = "xyz";
        String cl2 = "abc";
        String ml1 = "efg";
        String ml2 = "hij";
        ImmutableDeltaLakeTable contents = ImmutableDeltaLakeTable.builder().lastCheckpoint(path).addCheckpointLocationHistory(cl1).addCheckpointLocationHistory(cl2).addMetadataLocationHistory(ml1).addMetadataLocationHistory(ml2).id(ID).build();
        ByteString bytes = ObjectTypes.Contents.newBuilder().setId(ID).setDeltaLakeTable(ObjectTypes.DeltaLakeTable.newBuilder().setLastCheckpoint(path).addCheckpointLocationHistory(cl1).addCheckpointLocationHistory(cl2).addMetadataLocationHistory(ml1).addMetadataLocationHistory(ml2)).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, ImmutableDeltaLakeTable>(bytes, contents);
    }

    private static Map.Entry<ByteString, Contents> getView() {
        String path = "SELECT * FROM foo.bar,";
        ImmutableSqlView contents = ImmutableSqlView.builder().dialect(SqlView.Dialect.DREMIO).sqlText(path).id(ID).build();
        ByteString bytes = ObjectTypes.Contents.newBuilder().setId(ID).setSqlView(ObjectTypes.SqlView.newBuilder().setSqlText(path).setDialect("DREMIO")).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, ImmutableSqlView>(bytes, contents);
    }
}

