/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.Optional;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.SqlView;
import org.projectnessie.store.ObjectTypes;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.StoreWorker;

public class TableCommitMetaStoreWorker
implements StoreWorker<Content, CommitMeta, Content.Type> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Serializer<CommitMeta> metaSerializer = new MetadataSerializer();

    public ByteString toStoreOnReferenceState(Content content) {
        ObjectTypes.Content.Builder builder = ObjectTypes.Content.newBuilder().setId(content.getId());
        if (content instanceof IcebergTable) {
            IcebergTable state = (IcebergTable)content;
            ObjectTypes.IcebergRefState.Builder stateBuilder = ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(state.getSnapshotId()).setSchemaId(state.getSchemaId()).setSpecId(state.getSpecId()).setSortOrderId(state.getSortOrderId());
            builder.setIcebergRefState(stateBuilder);
        } else if (content instanceof DeltaLakeTable) {
            ObjectTypes.DeltaLakeTable.Builder table = ObjectTypes.DeltaLakeTable.newBuilder().addAllMetadataLocationHistory(((DeltaLakeTable)content).getMetadataLocationHistory()).addAllCheckpointLocationHistory(((DeltaLakeTable)content).getCheckpointLocationHistory());
            String lastCheckpoint = ((DeltaLakeTable)content).getLastCheckpoint();
            if (lastCheckpoint != null) {
                table.setLastCheckpoint(lastCheckpoint);
            }
            builder.setDeltaLakeTable(table);
        } else if (content instanceof SqlView) {
            SqlView view = (SqlView)content;
            builder.setSqlView(ObjectTypes.SqlView.newBuilder().setDialect(view.getDialect().name()).setSqlText(view.getSqlText()));
        } else {
            throw new IllegalArgumentException("Unknown type " + content);
        }
        return builder.build().toByteString();
    }

    public ByteString toStoreGlobalState(Content content) {
        ObjectTypes.Content.Builder builder = ObjectTypes.Content.newBuilder().setId(content.getId());
        if (!(content instanceof IcebergTable)) {
            throw new IllegalArgumentException("Unknown type " + content);
        }
        IcebergTable state = (IcebergTable)content;
        ObjectTypes.IcebergMetadataPointer.Builder stateBuilder = ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation(state.getMetadataLocation());
        builder.setIcebergMetadataPointer(stateBuilder);
        return builder.build().toByteString();
    }

    public Content valueFromStore(ByteString onReferenceValue, Optional<ByteString> globalState) {
        ObjectTypes.Content content = TableCommitMetaStoreWorker.parse(onReferenceValue);
        Optional<ObjectTypes.Content> globalContent = globalState.map(TableCommitMetaStoreWorker::parse);
        switch (content.getObjectTypeCase()) {
            case DELTA_LAKE_TABLE: {
                ImmutableDeltaLakeTable.Builder builder = ImmutableDeltaLakeTable.builder().id(content.getId()).addAllMetadataLocationHistory((Iterable)content.getDeltaLakeTable().getMetadataLocationHistoryList()).addAllCheckpointLocationHistory((Iterable)content.getDeltaLakeTable().getCheckpointLocationHistoryList());
                if (content.getDeltaLakeTable().getLastCheckpoint() != null) {
                    builder.lastCheckpoint(content.getDeltaLakeTable().getLastCheckpoint());
                }
                return builder.build();
            }
            case ICEBERG_REF_STATE: {
                ObjectTypes.Content global = globalContent.orElseThrow(TableCommitMetaStoreWorker::noIcebergMetadataPointer);
                if (!global.hasIcebergMetadataPointer()) {
                    throw TableCommitMetaStoreWorker.noIcebergMetadataPointer();
                }
                return ImmutableIcebergTable.builder().metadataLocation(global.getIcebergMetadataPointer().getMetadataLocation()).snapshotId(content.getIcebergRefState().getSnapshotId()).schemaId(content.getIcebergRefState().getSchemaId()).specId(content.getIcebergRefState().getSpecId()).sortOrderId(content.getIcebergRefState().getSortOrderId()).id(content.getId()).build();
            }
            case SQL_VIEW: {
                ObjectTypes.SqlView view = content.getSqlView();
                return ImmutableSqlView.builder().dialect(SqlView.Dialect.valueOf((String)view.getDialect())).sqlText(view.getSqlText()).id(content.getId()).build();
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)content.getObjectTypeCase()));
    }

    private static IllegalArgumentException noIcebergMetadataPointer() {
        return new IllegalArgumentException("Iceberg content from reference must have global state, but has none");
    }

    public String getId(Content content) {
        return content.getId();
    }

    public Byte getPayload(Content content) {
        if (content instanceof IcebergTable) {
            return (byte)Content.Type.ICEBERG_TABLE.ordinal();
        }
        if (content instanceof DeltaLakeTable) {
            return (byte)Content.Type.DELTA_LAKE_TABLE.ordinal();
        }
        if (content instanceof SqlView) {
            return (byte)Content.Type.VIEW.ordinal();
        }
        throw new IllegalArgumentException("Unknown type " + content);
    }

    public Content.Type getType(Byte payload) {
        if (payload == null || payload > Content.Type.values().length || payload < 0) {
            throw new IllegalArgumentException(String.format("Cannot create type from payload. Payload %d does not exist", payload));
        }
        return Content.Type.values()[payload];
    }

    public boolean requiresGlobalState(Content content) {
        return content instanceof IcebergTable;
    }

    private static ObjectTypes.Content parse(ByteString onReferenceValue) {
        try {
            return ObjectTypes.Content.parseFrom(onReferenceValue);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failure parsing data", e);
        }
    }

    public Serializer<CommitMeta> getMetadataSerializer() {
        return this.metaSerializer;
    }

    private static class MetadataSerializer
    implements Serializer<CommitMeta> {
        private MetadataSerializer() {
        }

        public ByteString toBytes(CommitMeta value) {
            try {
                return ByteString.copyFrom((byte[])MAPPER.writeValueAsBytes((Object)value));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Couldn't serialize commit meta %s", value), e);
            }
        }

        public CommitMeta fromBytes(ByteString bytes) {
            try {
                return (CommitMeta)MAPPER.readValue(bytes.toByteArray(), CommitMeta.class);
            }
            catch (IOException e) {
                return ImmutableCommitMeta.builder().message("unknown").committer("unknown").hash("unknown").build();
            }
        }
    }
}

