/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.server.store.TableCommitMetaStoreWorker;
import org.projectnessie.store.ObjectTypes;

class TestStoreWorker {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String ID = "x";
    private final TableCommitMetaStoreWorker worker = new TableCommitMetaStoreWorker();

    TestStoreWorker() {
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testDeserialization(Map.Entry<ByteString, Content> entry) {
        Content actual = this.worker.valueFromStore(entry.getKey(), Optional.empty());
        Assertions.assertEquals((Object)entry.getValue(), (Object)actual);
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testSerialization(Map.Entry<ByteString, Content> entry) {
        ByteString actual = this.worker.toStoreOnReferenceState(entry.getValue());
        Assertions.assertEquals((Object)entry.getKey(), (Object)actual);
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testSerde(Map.Entry<ByteString, Content> entry) {
        ByteString actualBytes = this.worker.toStoreOnReferenceState(entry.getValue());
        Assertions.assertEquals((Object)entry.getValue(), (Object)this.worker.valueFromStore(actualBytes, Optional.empty()));
        Content actualContent = this.worker.valueFromStore(entry.getKey(), Optional.empty());
        Assertions.assertEquals((Object)entry.getKey(), (Object)this.worker.toStoreOnReferenceState(actualContent));
    }

    @Test
    void testSerdeIceberg() {
        String path = "foo/bar";
        IcebergTable table = IcebergTable.of((String)path, (long)42L, (int)43, (int)44, (int)45, (String)ID);
        ObjectTypes.Content protoTableGlobal = ObjectTypes.Content.newBuilder().setId(ID).setIcebergMetadataPointer(ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation(path)).build();
        ObjectTypes.Content protoOnRef = ObjectTypes.Content.newBuilder().setId(ID).setIcebergRefState(ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(42L).setSchemaId(43).setSpecId(44).setSortOrderId(45)).build();
        ByteString tableGlobalBytes = this.worker.toStoreGlobalState((Content)table);
        ByteString snapshotBytes = this.worker.toStoreOnReferenceState((Content)table);
        Assertions.assertEquals((Object)protoTableGlobal.toByteString(), (Object)tableGlobalBytes);
        Assertions.assertEquals((Object)protoOnRef.toByteString(), (Object)snapshotBytes);
        Content deserialized = this.worker.valueFromStore(snapshotBytes, Optional.of(tableGlobalBytes));
        Assertions.assertEquals((Object)table, (Object)deserialized);
    }

    @Test
    void testSerdeIcebergView() {
        String path = "foo/view";
        String dialect = "Dremio";
        String sqlText = "select * from world";
        IcebergView view = IcebergView.of((String)ID, (String)path, (int)1, (int)123, (String)dialect, (String)sqlText);
        ObjectTypes.Content protoTableGlobal = ObjectTypes.Content.newBuilder().setId(ID).setIcebergMetadataPointer(ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation(path)).build();
        ObjectTypes.Content protoOnRef = ObjectTypes.Content.newBuilder().setId(ID).setIcebergViewState(ObjectTypes.IcebergViewState.newBuilder().setVersionId(1).setDialect(dialect).setSchemaId(123).setSqlText(sqlText)).build();
        ByteString tableGlobalBytes = this.worker.toStoreGlobalState((Content)view);
        ByteString snapshotBytes = this.worker.toStoreOnReferenceState((Content)view);
        Assertions.assertEquals((Object)protoTableGlobal.toByteString(), (Object)tableGlobalBytes);
        Assertions.assertEquals((Object)protoOnRef.toByteString(), (Object)snapshotBytes);
        Content deserialized = this.worker.valueFromStore(snapshotBytes, Optional.of(tableGlobalBytes));
        Assertions.assertEquals((Object)view, (Object)deserialized);
    }

    @Test
    void testCommitSerde() throws JsonProcessingException {
        ImmutableCommitMeta expectedCommit = ImmutableCommitMeta.builder().commitTime(Instant.now()).authorTime(Instant.now()).author("bill").committer("ted").hash("xyz").message("commit msg").build();
        ByteString expectedBytes = ByteString.copyFrom((byte[])MAPPER.writeValueAsBytes((Object)expectedCommit));
        CommitMeta actualCommit = (CommitMeta)this.worker.getMetadataSerializer().fromBytes(expectedBytes);
        Assertions.assertEquals((Object)expectedCommit, (Object)actualCommit);
        ByteString actualBytes = this.worker.getMetadataSerializer().toBytes((Object)expectedCommit);
        Assertions.assertEquals((Object)expectedBytes, (Object)actualBytes);
        actualBytes = this.worker.getMetadataSerializer().toBytes((Object)expectedCommit);
        Assertions.assertEquals((Object)expectedCommit, (Object)this.worker.getMetadataSerializer().fromBytes(actualBytes));
        actualCommit = (CommitMeta)this.worker.getMetadataSerializer().fromBytes(expectedBytes);
        Assertions.assertEquals((Object)expectedBytes, (Object)this.worker.getMetadataSerializer().toBytes((Object)actualCommit));
    }

    private static Stream<Map.Entry<ByteString, Content>> provideDeserialization() {
        return Stream.of(TestStoreWorker.getDelta());
    }

    private static Map.Entry<ByteString, Content> getDelta() {
        String path = "foo/bar";
        String cl1 = "xyz";
        String cl2 = "abc";
        String ml1 = "efg";
        String ml2 = "hij";
        ImmutableDeltaLakeTable content = ImmutableDeltaLakeTable.builder().lastCheckpoint(path).addCheckpointLocationHistory(cl1).addCheckpointLocationHistory(cl2).addMetadataLocationHistory(ml1).addMetadataLocationHistory(ml2).id(ID).build();
        ByteString bytes = ObjectTypes.Content.newBuilder().setId(ID).setDeltaLakeTable(ObjectTypes.DeltaLakeTable.newBuilder().setLastCheckpoint(path).addCheckpointLocationHistory(cl1).addCheckpointLocationHistory(cl2).addMetadataLocationHistory(ml1).addMetadataLocationHistory(ml2)).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, ImmutableDeltaLakeTable>(bytes, content);
    }
}

