/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.Namespace;
import org.projectnessie.server.store.TableCommitMetaStoreWorker;
import org.projectnessie.server.store.proto.ObjectTypes;

class TestStoreWorker {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String ID = "x";
    private final TableCommitMetaStoreWorker worker = new TableCommitMetaStoreWorker();

    TestStoreWorker() {
    }

    @Test
    void tableMetadataLocationGlobalNotAvailable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.worker.valueFromStore(ObjectTypes.Content.newBuilder().setId("cid").setIcebergRefState(ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(42L).setSchemaId(43).setSpecId(44).setSortOrderId(45)).build().toByteString(), () -> null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Iceberg content from reference must have global state, but has none");
    }

    @Test
    void tableMetadataLocationGlobal() {
        Content value = this.worker.valueFromStore(ObjectTypes.Content.newBuilder().setId("cid").setIcebergRefState(ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(42L).setSchemaId(43).setSpecId(44).setSortOrderId(45)).build().toByteString(), () -> ObjectTypes.Content.newBuilder().setId("cid").setIcebergMetadataPointer(ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation("metadata-location")).build().toByteString());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)value).isInstanceOf(IcebergTable.class)).asInstanceOf(InstanceOfAssertFactories.type(IcebergTable.class))).extracting(new Function[]{IcebergTable::getMetadataLocation, IcebergTable::getSnapshotId, IcebergTable::getSchemaId, IcebergTable::getSpecId, IcebergTable::getSortOrderId}).containsExactly(new Object[]{"metadata-location", 42L, 43, 44, 45});
    }

    @Test
    void tableMetadataLocationOnRef() {
        Content value = this.worker.valueFromStore(ObjectTypes.Content.newBuilder().setId("cid").setIcebergRefState(ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(42L).setSchemaId(43).setSpecId(44).setSortOrderId(45).setMetadataLocation("metadata-location")).build().toByteString(), () -> null);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)value).isInstanceOf(IcebergTable.class)).asInstanceOf(InstanceOfAssertFactories.type(IcebergTable.class))).extracting(new Function[]{IcebergTable::getMetadataLocation, IcebergTable::getSnapshotId, IcebergTable::getSchemaId, IcebergTable::getSpecId, IcebergTable::getSortOrderId}).containsExactly(new Object[]{"metadata-location", 42L, 43, 44, 45});
    }

    @Test
    void viewMetadataLocationGlobalNotAvailable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.worker.valueFromStore(ObjectTypes.Content.newBuilder().setId("cid").setIcebergViewState(ObjectTypes.IcebergViewState.newBuilder().setVersionId(42)).build().toByteString(), () -> null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Iceberg content from reference must have global state, but has none");
    }

    @Test
    void viewMetadataLocationGlobal() {
        Content value = this.worker.valueFromStore(ObjectTypes.Content.newBuilder().setId("cid").setIcebergViewState(ObjectTypes.IcebergViewState.newBuilder().setVersionId(42)).build().toByteString(), () -> ObjectTypes.Content.newBuilder().setId("cid").setIcebergMetadataPointer(ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation("metadata-location")).build().toByteString());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)value).isInstanceOf(IcebergView.class)).asInstanceOf(InstanceOfAssertFactories.type(IcebergView.class))).extracting(new Function[]{IcebergView::getMetadataLocation, IcebergView::getVersionId}).containsExactly(new Object[]{"metadata-location", 42});
    }

    static Stream<Arguments> requiresGlobalStateModelType() {
        return Stream.of(Arguments.of((Object[])new Object[]{Namespace.of((String[])new String[]{"foo"}), false, ObjectTypes.Content.newBuilder().setId("foo").setNamespace(ObjectTypes.Namespace.newBuilder().addElements("foo")), null, false, Content.Type.NAMESPACE}), Arguments.of((Object[])new Object[]{IcebergTable.of((String)"metadata", (long)42L, (int)43, (int)44, (int)45, (String)"cid"), false, ObjectTypes.Content.newBuilder().setId("cid").setIcebergRefState(ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(42L).setSchemaId(43).setSpecId(44).setSortOrderId(45)), ObjectTypes.Content.newBuilder().setId("cid").setIcebergMetadataPointer(ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation("metadata")), true, Content.Type.ICEBERG_TABLE}), Arguments.of((Object[])new Object[]{IcebergTable.of((String)"metadata", (long)42L, (int)43, (int)44, (int)45, (String)"cid"), false, ObjectTypes.Content.newBuilder().setId("cid").setIcebergRefState(ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(42L).setSchemaId(43).setSpecId(44).setSortOrderId(45).setMetadataLocation("metadata")), null, false, Content.Type.ICEBERG_TABLE}), Arguments.of((Object[])new Object[]{IcebergView.of((String)"cid", (String)"metadata", (int)42, (int)43, (String)"dialect", (String)"sqlText"), false, ObjectTypes.Content.newBuilder().setId("cid").setIcebergViewState(ObjectTypes.IcebergViewState.newBuilder().setVersionId(42).setSchemaId(43).setDialect("dialect").setSqlText("sqlText")), ObjectTypes.Content.newBuilder().setId("cid").setIcebergMetadataPointer(ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation("metadata")), true, Content.Type.ICEBERG_VIEW}), Arguments.of((Object[])new Object[]{IcebergView.of((String)"cid", (String)"metadata", (int)42, (int)43, (String)"dialect", (String)"sqlText"), false, ObjectTypes.Content.newBuilder().setId("cid").setIcebergViewState(ObjectTypes.IcebergViewState.newBuilder().setVersionId(42).setSchemaId(43).setDialect("dialect").setSqlText("sqlText").setMetadataLocation("metadata")), null, false, Content.Type.ICEBERG_VIEW}), Arguments.of((Object[])new Object[]{ImmutableDeltaLakeTable.builder().id("cid").addCheckpointLocationHistory("check").addMetadataLocationHistory("meta").build(), false, ObjectTypes.Content.newBuilder().setId("cid").setDeltaLakeTable(ObjectTypes.DeltaLakeTable.newBuilder().addCheckpointLocationHistory("check").addMetadataLocationHistory("meta")), null, false, Content.Type.DELTA_LAKE_TABLE}));
    }

    @ParameterizedTest
    @MethodSource(value={"requiresGlobalStateModelType"})
    void requiresGlobalStateModelType(Content content, boolean modelGlobal, ObjectTypes.Content.Builder onRefBuilder, ObjectTypes.Content.Builder globalBuilder, boolean storeGlobal, Content.Type type) {
        Function[] functionArray = new Function[2];
        functionArray[0] = arg_0 -> ((TableCommitMetaStoreWorker)this.worker).requiresGlobalState(arg_0);
        functionArray[1] = arg_0 -> ((TableCommitMetaStoreWorker)this.worker).getType(arg_0);
        Assertions.assertThat((Object)content).extracting(functionArray).containsExactly(new Object[]{modelGlobal, type});
        ByteString onRef = onRefBuilder.build().toByteString();
        ByteString global = globalBuilder != null ? globalBuilder.build().toByteString() : null;
        Function[] functionArray2 = new Function[2];
        functionArray2[0] = arg_0 -> ((TableCommitMetaStoreWorker)this.worker).requiresGlobalState(arg_0);
        functionArray2[1] = arg_0 -> ((TableCommitMetaStoreWorker)this.worker).getType(arg_0);
        ((ObjectAssert)Assertions.assertThat((Iterable)onRef).asInstanceOf(InstanceOfAssertFactories.type(ByteString.class))).extracting(functionArray2).containsExactly(new Object[]{storeGlobal, type});
        Assertions.assertThat((Object)this.worker.valueFromStore(onRef, () -> global)).isEqualTo((Object)content);
        if (storeGlobal) {
            if (onRefBuilder.hasIcebergRefState()) {
                onRef = onRefBuilder.setIcebergRefState(onRefBuilder.getIcebergRefStateBuilder().setMetadataLocation(((IcebergTable)content).getMetadataLocation())).build().toByteString();
            } else if (onRefBuilder.hasIcebergViewState()) {
                onRef = onRefBuilder.setIcebergViewState(onRefBuilder.getIcebergViewStateBuilder().setMetadataLocation(((IcebergView)content).getMetadataLocation())).build().toByteString();
            }
        }
        Assertions.assertThat((Object)content).extracting(arg_0 -> ((TableCommitMetaStoreWorker)this.worker).toStoreOnReferenceState(arg_0)).isEqualTo((Object)onRef);
        if (storeGlobal) {
            Assertions.assertThat((Object)content).extracting(arg_0 -> ((TableCommitMetaStoreWorker)this.worker).toStoreGlobalState(arg_0)).isEqualTo((Object)global);
        }
    }

    @Test
    void viewMetadataLocationOnRef() {
        Content value = this.worker.valueFromStore(ObjectTypes.Content.newBuilder().setId("cid").setIcebergViewState(ObjectTypes.IcebergViewState.newBuilder().setVersionId(42).setMetadataLocation("metadata-location")).build().toByteString(), () -> null);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)value).isInstanceOf(IcebergView.class)).asInstanceOf(InstanceOfAssertFactories.type(IcebergView.class))).extracting(new Function[]{IcebergView::getMetadataLocation, IcebergView::getVersionId}).containsExactly(new Object[]{"metadata-location", 42});
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testDeserialization(Map.Entry<ByteString, Content> entry) {
        Content actual = this.worker.valueFromStore(entry.getKey(), () -> null);
        Assertions.assertThat((Object)actual).isEqualTo((Object)entry.getValue());
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testSerialization(Map.Entry<ByteString, Content> entry) {
        ByteString actual = this.worker.toStoreOnReferenceState(entry.getValue());
        Assertions.assertThat((Iterable)actual).isEqualTo((Object)entry.getKey());
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testSerde(Map.Entry<ByteString, Content> entry) {
        ByteString actualBytes = this.worker.toStoreOnReferenceState(entry.getValue());
        Assertions.assertThat((Object)this.worker.valueFromStore(actualBytes, () -> null)).isEqualTo((Object)entry.getValue());
        Content actualContent = this.worker.valueFromStore(entry.getKey(), () -> null);
        Assertions.assertThat((Iterable)this.worker.toStoreOnReferenceState(actualContent)).isEqualTo((Object)entry.getKey());
    }

    @Test
    void testSerdeIceberg() {
        String path = "foo/bar";
        IcebergTable table = IcebergTable.of((String)path, (long)42L, (int)43, (int)44, (int)45, (String)ID);
        ObjectTypes.Content protoTableGlobal = ObjectTypes.Content.newBuilder().setId(ID).setIcebergMetadataPointer(ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation(path)).build();
        ObjectTypes.Content protoOnRef = ObjectTypes.Content.newBuilder().setId(ID).setIcebergRefState(ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(42L).setSchemaId(43).setSpecId(44).setSortOrderId(45).setMetadataLocation(path)).build();
        ByteString tableGlobalBytes = this.worker.toStoreGlobalState((Content)table);
        ByteString snapshotBytes = this.worker.toStoreOnReferenceState((Content)table);
        Assertions.assertThat((Iterable)tableGlobalBytes).isEqualTo((Object)protoTableGlobal.toByteString());
        Assertions.assertThat((Iterable)snapshotBytes).isEqualTo((Object)protoOnRef.toByteString());
        Content deserialized = this.worker.valueFromStore(snapshotBytes, () -> tableGlobalBytes);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)table);
    }

    @Test
    void testSerdeIcebergView() {
        String path = "foo/view";
        String dialect = "Dremio";
        String sqlText = "select * from world";
        IcebergView view = IcebergView.of((String)ID, (String)path, (int)1, (int)123, (String)dialect, (String)sqlText);
        ObjectTypes.Content protoTableGlobal = ObjectTypes.Content.newBuilder().setId(ID).setIcebergMetadataPointer(ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation(path)).build();
        ObjectTypes.Content protoOnRef = ObjectTypes.Content.newBuilder().setId(ID).setIcebergViewState(ObjectTypes.IcebergViewState.newBuilder().setVersionId(1).setDialect(dialect).setSchemaId(123).setSqlText(sqlText).setMetadataLocation(path)).build();
        ByteString tableGlobalBytes = this.worker.toStoreGlobalState((Content)view);
        ByteString snapshotBytes = this.worker.toStoreOnReferenceState((Content)view);
        Assertions.assertThat((Iterable)tableGlobalBytes).isEqualTo((Object)protoTableGlobal.toByteString());
        Assertions.assertThat((Iterable)snapshotBytes).isEqualTo((Object)protoOnRef.toByteString());
        Content deserialized = this.worker.valueFromStore(snapshotBytes, () -> tableGlobalBytes);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)view);
    }

    @Test
    void testCommitSerde() throws JsonProcessingException {
        ImmutableCommitMeta expectedCommit = ImmutableCommitMeta.builder().commitTime(Instant.now()).authorTime(Instant.now()).author("bill").committer("ted").hash("xyz").message("commit msg").build();
        ByteString expectedBytes = ByteString.copyFrom((byte[])MAPPER.writeValueAsBytes((Object)expectedCommit));
        CommitMeta actualCommit = (CommitMeta)this.worker.getMetadataSerializer().fromBytes(expectedBytes);
        Assertions.assertThat((Object)actualCommit).isEqualTo((Object)expectedCommit);
        ByteString actualBytes = this.worker.getMetadataSerializer().toBytes((Object)expectedCommit);
        Assertions.assertThat((Iterable)actualBytes).isEqualTo((Object)expectedBytes);
        actualBytes = this.worker.getMetadataSerializer().toBytes((Object)expectedCommit);
        Assertions.assertThat((Object)((CommitMeta)this.worker.getMetadataSerializer().fromBytes(actualBytes))).isEqualTo((Object)expectedCommit);
        actualCommit = (CommitMeta)this.worker.getMetadataSerializer().fromBytes(expectedBytes);
        Assertions.assertThat((Iterable)this.worker.getMetadataSerializer().toBytes((Object)actualCommit)).isEqualTo((Object)expectedBytes);
    }

    private static Stream<Map.Entry<ByteString, Content>> provideDeserialization() {
        return Stream.of(TestStoreWorker.getDelta(), TestStoreWorker.getNamespace(), TestStoreWorker.getNamespaceWithProperties());
    }

    private static Map.Entry<ByteString, Content> getDelta() {
        String path = "foo/bar";
        String cl1 = "xyz";
        String cl2 = "abc";
        String ml1 = "efg";
        String ml2 = "hij";
        ImmutableDeltaLakeTable content = ImmutableDeltaLakeTable.builder().lastCheckpoint(path).addCheckpointLocationHistory(cl1).addCheckpointLocationHistory(cl2).addMetadataLocationHistory(ml1).addMetadataLocationHistory(ml2).id(ID).build();
        ByteString bytes = ObjectTypes.Content.newBuilder().setId(ID).setDeltaLakeTable(ObjectTypes.DeltaLakeTable.newBuilder().setLastCheckpoint(path).addCheckpointLocationHistory(cl1).addCheckpointLocationHistory(cl2).addMetadataLocationHistory(ml1).addMetadataLocationHistory(ml2)).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, ImmutableDeltaLakeTable>(bytes, content);
    }

    private static Map.Entry<ByteString, Content> getNamespace() {
        List<String> elements = Arrays.asList("a", "b.c", "d");
        Namespace namespace = Namespace.of(elements);
        ByteString bytes = ObjectTypes.Content.newBuilder().setId(namespace.getId()).setNamespace(ObjectTypes.Namespace.newBuilder().addAllElements(elements).build()).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, Namespace>(bytes, namespace);
    }

    private static Map.Entry<ByteString, Content> getNamespaceWithProperties() {
        List<String> elements = Arrays.asList("a", "b.c", "d");
        ImmutableMap properties = ImmutableMap.of((Object)"key1", (Object)"val1");
        Namespace namespace = Namespace.of(elements, (Map)properties);
        ByteString bytes = ObjectTypes.Content.newBuilder().setId(namespace.getId()).setNamespace(ObjectTypes.Namespace.newBuilder().addAllElements(elements).putAllProperties((Map)properties).build()).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, Namespace>(bytes, namespace);
    }
}

