/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.function.Supplier;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableIcebergView;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.server.store.proto.ObjectTypes;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.StoreWorker;

public class TableCommitMetaStoreWorker
implements StoreWorker<Content, CommitMeta, Content.Type> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Serializer<CommitMeta> metaSerializer = new MetadataSerializer();

    public ByteString toStoreOnReferenceState(Content content) {
        ObjectTypes.Content.Builder builder = ObjectTypes.Content.newBuilder().setId(content.getId());
        if (content instanceof IcebergTable) {
            IcebergTable table = (IcebergTable)content;
            ObjectTypes.IcebergRefState.Builder stateBuilder = ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(table.getSnapshotId()).setSchemaId(table.getSchemaId()).setSpecId(table.getSpecId()).setSortOrderId(table.getSortOrderId()).setMetadataLocation(table.getMetadataLocation());
            builder.setIcebergRefState(stateBuilder);
        } else if (content instanceof IcebergView) {
            IcebergView view = (IcebergView)content;
            builder.setIcebergViewState(ObjectTypes.IcebergViewState.newBuilder().setVersionId(view.getVersionId()).setSchemaId(view.getSchemaId()).setDialect(view.getDialect()).setSqlText(view.getSqlText()).setMetadataLocation(view.getMetadataLocation()));
        } else if (content instanceof DeltaLakeTable) {
            ObjectTypes.DeltaLakeTable.Builder table = ObjectTypes.DeltaLakeTable.newBuilder().addAllMetadataLocationHistory((Iterable)((DeltaLakeTable)content).getMetadataLocationHistory()).addAllCheckpointLocationHistory((Iterable)((DeltaLakeTable)content).getCheckpointLocationHistory());
            String lastCheckpoint = ((DeltaLakeTable)content).getLastCheckpoint();
            if (lastCheckpoint != null) {
                table.setLastCheckpoint(lastCheckpoint);
            }
            builder.setDeltaLakeTable(table);
        } else if (content instanceof Namespace) {
            Namespace ns = (Namespace)content;
            builder.setNamespace(ObjectTypes.Namespace.newBuilder().addAllElements((Iterable)ns.getElements()).putAllProperties(ns.getProperties()).build());
        } else {
            throw new IllegalArgumentException("Unknown type " + content);
        }
        return builder.build().toByteString();
    }

    public ByteString toStoreGlobalState(Content content) {
        ObjectTypes.Content.Builder builder = ObjectTypes.Content.newBuilder().setId(content.getId());
        if (content instanceof IcebergTable) {
            IcebergTable state = (IcebergTable)content;
            ObjectTypes.IcebergMetadataPointer.Builder stateBuilder = ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation(state.getMetadataLocation());
            builder.setIcebergMetadataPointer(stateBuilder);
        } else if (content instanceof IcebergView) {
            IcebergView state = (IcebergView)content;
            ObjectTypes.IcebergMetadataPointer.Builder stateBuilder = ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation(state.getMetadataLocation());
            builder.setIcebergMetadataPointer(stateBuilder);
        } else {
            throw new IllegalArgumentException("Unknown type " + content);
        }
        return builder.build().toByteString();
    }

    public Content valueFromStore(ByteString onReferenceValue, Supplier<ByteString> globalState) {
        ObjectTypes.Content content = TableCommitMetaStoreWorker.parse(onReferenceValue);
        switch (content.getObjectTypeCase()) {
            case DELTA_LAKE_TABLE: {
                ObjectTypes.DeltaLakeTable deltaLakeTable = content.getDeltaLakeTable();
                ImmutableDeltaLakeTable.Builder builder = ImmutableDeltaLakeTable.builder().id(content.getId()).addAllMetadataLocationHistory((Iterable)deltaLakeTable.getMetadataLocationHistoryList()).addAllCheckpointLocationHistory((Iterable)deltaLakeTable.getCheckpointLocationHistoryList());
                if (deltaLakeTable.hasLastCheckpoint()) {
                    builder.lastCheckpoint(content.getDeltaLakeTable().getLastCheckpoint());
                }
                return builder.build();
            }
            case ICEBERG_REF_STATE: {
                ObjectTypes.IcebergRefState table = content.getIcebergRefState();
                String metadataLocation = table.hasMetadataLocation() ? table.getMetadataLocation() : this.metadataLocationFromGlobal(globalState);
                return ImmutableIcebergTable.builder().metadataLocation(metadataLocation).snapshotId(table.getSnapshotId()).schemaId(table.getSchemaId()).specId(table.getSpecId()).sortOrderId(table.getSortOrderId()).id(content.getId()).build();
            }
            case ICEBERG_VIEW_STATE: {
                ObjectTypes.IcebergViewState view = content.getIcebergViewState();
                String metadataLocation = view.hasMetadataLocation() ? view.getMetadataLocation() : this.metadataLocationFromGlobal(globalState);
                return ImmutableIcebergView.builder().metadataLocation(metadataLocation).versionId(view.getVersionId()).schemaId(view.getSchemaId()).dialect(view.getDialect()).sqlText(view.getSqlText()).id(content.getId()).build();
            }
            case NAMESPACE: {
                ObjectTypes.Namespace namespace = content.getNamespace();
                return ImmutableNamespace.builder().elements((Iterable)namespace.getElementsList()).putAllProperties(namespace.getPropertiesMap()).build();
            }
        }
        throw new IllegalArgumentException("Unknown type " + content.getObjectTypeCase());
    }

    private String metadataLocationFromGlobal(Supplier<ByteString> globalContent) {
        ByteString globalBytes = globalContent.get();
        if (globalBytes == null) {
            throw TableCommitMetaStoreWorker.noIcebergMetadataPointer();
        }
        ObjectTypes.Content global = TableCommitMetaStoreWorker.parse(globalBytes);
        if (!global.hasIcebergMetadataPointer()) {
            throw TableCommitMetaStoreWorker.noIcebergMetadataPointer();
        }
        return global.getIcebergMetadataPointer().getMetadataLocation();
    }

    private static IllegalArgumentException noIcebergMetadataPointer() {
        return new IllegalArgumentException("Iceberg content from reference must have global state, but has none");
    }

    public String getId(Content content) {
        return content.getId();
    }

    public Byte getPayload(Content content) {
        if (content instanceof IcebergTable) {
            return (byte)Content.Type.ICEBERG_TABLE.ordinal();
        }
        if (content instanceof DeltaLakeTable) {
            return (byte)Content.Type.DELTA_LAKE_TABLE.ordinal();
        }
        if (content instanceof IcebergView) {
            return (byte)Content.Type.ICEBERG_VIEW.ordinal();
        }
        if (content instanceof Namespace) {
            return (byte)Content.Type.NAMESPACE.ordinal();
        }
        throw new IllegalArgumentException("Unknown type " + content);
    }

    public Content.Type getType(Content content) {
        return content.getType();
    }

    public Content.Type getType(Byte payload) {
        if (payload == null || payload > Content.Type.values().length || payload < 0) {
            throw new IllegalArgumentException(String.format("Cannot create type from payload. Payload %d does not exist", payload));
        }
        return Content.Type.values()[payload];
    }

    public Content.Type getType(ByteString onRefContent) {
        ObjectTypes.Content parsed = TableCommitMetaStoreWorker.parse(onRefContent);
        if (parsed.hasIcebergRefState()) {
            return Content.Type.ICEBERG_TABLE;
        }
        if (parsed.hasIcebergViewState()) {
            return Content.Type.ICEBERG_VIEW;
        }
        if (parsed.hasDeltaLakeTable()) {
            return Content.Type.DELTA_LAKE_TABLE;
        }
        if (parsed.hasNamespace()) {
            return Content.Type.NAMESPACE;
        }
        throw new IllegalArgumentException("Unsupported on-ref content " + parsed);
    }

    public boolean requiresGlobalState(Content content) {
        switch (content.getType()) {
            default: 
        }
        return false;
    }

    public boolean requiresGlobalState(ByteString content) {
        ObjectTypes.Content parsed = TableCommitMetaStoreWorker.parse(content);
        switch (parsed.getObjectTypeCase()) {
            case ICEBERG_REF_STATE: {
                return !parsed.getIcebergRefState().hasMetadataLocation();
            }
            case ICEBERG_VIEW_STATE: {
                return !parsed.getIcebergViewState().hasMetadataLocation();
            }
        }
        return false;
    }

    private static ObjectTypes.Content parse(ByteString value) {
        try {
            return ObjectTypes.Content.parseFrom((ByteString)value);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failure parsing data", e);
        }
    }

    public Serializer<CommitMeta> getMetadataSerializer() {
        return this.metaSerializer;
    }

    public boolean isNamespace(ByteString type) {
        try {
            return Content.Type.NAMESPACE == this.getType(type);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class MetadataSerializer
    implements Serializer<CommitMeta> {
        private MetadataSerializer() {
        }

        public ByteString toBytes(CommitMeta value) {
            try {
                return ByteString.copyFrom((byte[])MAPPER.writeValueAsBytes((Object)value));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Couldn't serialize commit meta %s", value), e);
            }
        }

        public CommitMeta fromBytes(ByteString bytes) {
            try {
                return (CommitMeta)MAPPER.readValue(bytes.toByteArray(), CommitMeta.class);
            }
            catch (IOException e) {
                return ImmutableCommitMeta.builder().message("unknown").committer("unknown").hash("unknown").build();
            }
        }
    }
}

