/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.cbor.databind.CBORMapper;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.GenericMetadata;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableIcebergView;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.server.store.proto.ObjectTypes;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;
import org.projectnessie.versioned.ImmutableContentAttachment;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.StoreWorker;

public class TableCommitMetaStoreWorker
implements StoreWorker<Content, CommitMeta, Content.Type> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final CBORMapper CBOR_MAPPER = new CBORMapper();
    private static final ContentAttachment.Format PREFERRED_ATTACHMENT_FORMAT = ContentAttachment.Format.CBOR;
    private static final EnumMap<ObjectTypes.ContentPartType, String> JSON_ARRAY_NAMES_FOR_PART_TYPE = new EnumMap(ObjectTypes.ContentPartType.class);
    private final Serializer<CommitMeta> metaSerializer = new MetadataSerializer();
    private static final List<IcebergAttachmentDefinition> ICEBERG_ATTACHMENT_DEFS;

    public ByteString toStoreOnReferenceState(Content content, Consumer<ContentAttachment> attachmentConsumer) {
        ObjectTypes.Content.Builder builder = ObjectTypes.Content.newBuilder().setId(content.getId());
        if (content instanceof IcebergTable) {
            TableCommitMetaStoreWorker.toStoreIcebergTable((IcebergTable)content, attachmentConsumer, builder);
        } else if (content instanceof IcebergView) {
            TableCommitMetaStoreWorker.toStoreIcebergView((IcebergView)content, attachmentConsumer, builder);
        } else if (content instanceof DeltaLakeTable) {
            TableCommitMetaStoreWorker.toStoreDeltaLakeTable((DeltaLakeTable)content, builder);
        } else if (content instanceof Namespace) {
            TableCommitMetaStoreWorker.toStoreNamespace((Namespace)content, builder);
        } else {
            throw new IllegalArgumentException("Unknown type " + content);
        }
        return builder.build().toByteString();
    }

    private static void toStoreDeltaLakeTable(DeltaLakeTable content, ObjectTypes.Content.Builder builder) {
        ObjectTypes.DeltaLakeTable.Builder table = ObjectTypes.DeltaLakeTable.newBuilder().addAllMetadataLocationHistory((Iterable)content.getMetadataLocationHistory()).addAllCheckpointLocationHistory((Iterable)content.getCheckpointLocationHistory());
        String lastCheckpoint = content.getLastCheckpoint();
        if (lastCheckpoint != null) {
            table.setLastCheckpoint(lastCheckpoint);
        }
        builder.setDeltaLakeTable(table);
    }

    private static void toStoreNamespace(Namespace content, ObjectTypes.Content.Builder builder) {
        builder.setNamespace(ObjectTypes.Namespace.newBuilder().addAllElements((Iterable)content.getElements()).putAllProperties(content.getProperties()).build());
    }

    private static void toStoreIcebergView(IcebergView view, Consumer<ContentAttachment> attachmentConsumer, ObjectTypes.Content.Builder builder) {
        ObjectTypes.IcebergViewState.Builder stateBuilder = ObjectTypes.IcebergViewState.newBuilder().setVersionId(view.getVersionId()).setSchemaId(view.getSchemaId()).setDialect(view.getDialect()).setSqlText(view.getSqlText()).setMetadataLocation(view.getMetadataLocation());
        TableCommitMetaStoreWorker.extractIcebergAttachments(attachmentConsumer, view.getMetadata(), view.getId(), formatVersion -> formatVersion == 1, arg_0 -> ((ObjectTypes.IcebergViewState.Builder)stateBuilder).setMetadata(arg_0), arg_0 -> ((ObjectTypes.IcebergViewState.Builder)stateBuilder).addCurrentParts(arg_0), arg_0 -> ((ObjectTypes.IcebergViewState.Builder)stateBuilder).addExtraParts(arg_0));
        builder.setIcebergViewState(stateBuilder);
    }

    private static void toStoreIcebergTable(IcebergTable table, Consumer<ContentAttachment> attachmentConsumer, ObjectTypes.Content.Builder builder) {
        ObjectTypes.IcebergRefState.Builder stateBuilder = ObjectTypes.IcebergRefState.newBuilder().setSnapshotId(table.getSnapshotId()).setSchemaId(table.getSchemaId()).setSpecId(table.getSpecId()).setSortOrderId(table.getSortOrderId()).setMetadataLocation(table.getMetadataLocation());
        TableCommitMetaStoreWorker.extractIcebergAttachments(attachmentConsumer, table.getMetadata(), table.getId(), formatVersion -> formatVersion >= 1 && formatVersion <= 2, arg_0 -> ((ObjectTypes.IcebergRefState.Builder)stateBuilder).setMetadata(arg_0), arg_0 -> ((ObjectTypes.IcebergRefState.Builder)stateBuilder).addCurrentParts(arg_0), arg_0 -> ((ObjectTypes.IcebergRefState.Builder)stateBuilder).addExtraParts(arg_0));
        builder.setIcebergRefState(stateBuilder);
    }

    private static void extractIcebergAttachments(Consumer<ContentAttachment> attachmentConsumer, GenericMetadata genericMetadata, String contentId, IntPredicate formatVersionChecker, Consumer<ObjectTypes.ContentPartReference.Builder> metadataRefConsumer, Consumer<ObjectTypes.ContentPartReference.Builder> currentPartRefConsumer, Consumer<ObjectTypes.ContentPartReference.Builder> morePartRefConsumer) {
        if (genericMetadata == null) {
            return;
        }
        JsonNode metadataRaw = genericMetadata.getMetadata().deepCopy();
        Preconditions.checkState((boolean)(metadataRaw instanceof ObjectNode), (Object)"Parsed JsonNode must be an object");
        ObjectNode metadata = (ObjectNode)metadataRaw;
        int formatVersion = metadata.get("format-version").asInt(-1);
        Preconditions.checkArgument((boolean)formatVersionChecker.test(formatVersion), (String)"Unsupported Iceberg metadata format version %s", (int)formatVersion);
        ICEBERG_ATTACHMENT_DEFS.forEach(def -> {
            JsonNode container = metadata.remove(def.metadataContainerField);
            if (container == null) {
                return;
            }
            Preconditions.checkArgument((boolean)container.isArray(), (String)"Metadata contains field '%s' but it is not an array", (Object)def.metadataContainerField);
            long currentId = metadata.get(def.metadataIdRefField).asLong();
            for (JsonNode jsonNode : container) {
                long id = jsonNode.get(def.childIdField).asLong();
                TableCommitMetaStoreWorker.extractedAttachment(contentId, def.contentPartType, id, jsonNode, attachmentConsumer, def.retainAllAsCurrent || id == currentId ? currentPartRefConsumer : morePartRefConsumer);
            }
        });
        TableCommitMetaStoreWorker.extractedAttachment(contentId, ObjectTypes.ContentPartType.SHALLOW_METADATA, null, (JsonNode)metadata, attachmentConsumer, metadataRefConsumer);
    }

    private static void extractedAttachment(String contentId, ObjectTypes.ContentPartType attachmentType, Long objectId, JsonNode jsonNode, Consumer<ContentAttachment> attachmentConsumer, Consumer<ObjectTypes.ContentPartReference.Builder> partRefConsumer) {
        String attachmentId = TableCommitMetaStoreWorker.hashForJson(jsonNode);
        ContentAttachmentKey key = ContentAttachmentKey.of((String)contentId, (String)attachmentType.name(), (String)attachmentId);
        ImmutableContentAttachment.Builder attachment = ContentAttachment.builder().key(key);
        if (objectId != null) {
            attachment.objectId(objectId);
        }
        attachmentConsumer.accept((ContentAttachment)TableCommitMetaStoreWorker.fromJson(attachment, jsonNode).build());
        ObjectTypes.ContentPartReference.Builder partReference = ObjectTypes.ContentPartReference.newBuilder().setType(attachmentType).setAttachmentId(attachmentId);
        if (objectId != null) {
            partReference.setObjectId(objectId.longValue());
        }
        partRefConsumer.accept(partReference);
    }

    public ByteString toStoreGlobalState(Content content) {
        ObjectTypes.Content.Builder builder = ObjectTypes.Content.newBuilder().setId(content.getId());
        if (content instanceof IcebergTable) {
            IcebergTable state = (IcebergTable)content;
            ObjectTypes.IcebergMetadataPointer.Builder stateBuilder = ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation(state.getMetadataLocation());
            builder.setIcebergMetadataPointer(stateBuilder);
        } else if (content instanceof IcebergView) {
            IcebergView state = (IcebergView)content;
            ObjectTypes.IcebergMetadataPointer.Builder stateBuilder = ObjectTypes.IcebergMetadataPointer.newBuilder().setMetadataLocation(state.getMetadataLocation());
            builder.setIcebergMetadataPointer(stateBuilder);
        } else {
            throw new IllegalArgumentException("Unknown type " + content);
        }
        return builder.build().toByteString();
    }

    public Content valueFromStore(ByteString onReferenceValue, Supplier<ByteString> globalState, Function<Stream<ContentAttachmentKey>, Stream<ContentAttachment>> attachmentsRetriever) {
        ObjectTypes.Content content = TableCommitMetaStoreWorker.parse(onReferenceValue);
        Supplier<String> metadataPointerSupplier = () -> {
            ByteString global = (ByteString)globalState.get();
            if (global == null) {
                throw TableCommitMetaStoreWorker.noIcebergMetadataPointer();
            }
            ObjectTypes.Content globalContent = TableCommitMetaStoreWorker.parse(global);
            if (!globalContent.hasIcebergMetadataPointer()) {
                throw TableCommitMetaStoreWorker.noIcebergMetadataPointer();
            }
            return globalContent.getIcebergMetadataPointer().getMetadataLocation();
        };
        switch (content.getObjectTypeCase()) {
            case DELTA_LAKE_TABLE: {
                return TableCommitMetaStoreWorker.valueFromStoreDeltaLakeTable(content);
            }
            case ICEBERG_REF_STATE: {
                return TableCommitMetaStoreWorker.valueFromStoreIcebergTable(attachmentsRetriever, content, metadataPointerSupplier);
            }
            case ICEBERG_VIEW_STATE: {
                return TableCommitMetaStoreWorker.valueFromStoreIcebergView(attachmentsRetriever, content, metadataPointerSupplier);
            }
            case NAMESPACE: {
                return TableCommitMetaStoreWorker.valueFromStoreNamespace(content);
            }
        }
        throw new IllegalArgumentException("Unknown type " + content.getObjectTypeCase());
    }

    private static ImmutableDeltaLakeTable valueFromStoreDeltaLakeTable(ObjectTypes.Content content) {
        ObjectTypes.DeltaLakeTable deltaLakeTable = content.getDeltaLakeTable();
        ImmutableDeltaLakeTable.Builder builder = ImmutableDeltaLakeTable.builder().id(content.getId()).addAllMetadataLocationHistory((Iterable)deltaLakeTable.getMetadataLocationHistoryList()).addAllCheckpointLocationHistory((Iterable)deltaLakeTable.getCheckpointLocationHistoryList());
        if (deltaLakeTable.hasLastCheckpoint()) {
            builder.lastCheckpoint(content.getDeltaLakeTable().getLastCheckpoint());
        }
        return builder.build();
    }

    private static ImmutableNamespace valueFromStoreNamespace(ObjectTypes.Content content) {
        ObjectTypes.Namespace namespace = content.getNamespace();
        return ImmutableNamespace.builder().id(content.getId()).elements((Iterable)namespace.getElementsList()).putAllProperties(namespace.getPropertiesMap()).build();
    }

    private static ImmutableIcebergTable valueFromStoreIcebergTable(Function<Stream<ContentAttachmentKey>, Stream<ContentAttachment>> attachmentsRetriever, ObjectTypes.Content content, Supplier<String> metadataPointerSupplier) {
        ObjectTypes.IcebergRefState table = content.getIcebergRefState();
        String metadataLocation = table.hasMetadataLocation() ? table.getMetadataLocation() : metadataPointerSupplier.get();
        ImmutableIcebergTable.Builder tableBuilder = IcebergTable.builder().metadataLocation(metadataLocation).snapshotId(table.getSnapshotId()).schemaId(table.getSchemaId()).specId(table.getSpecId()).sortOrderId(table.getSortOrderId()).id(content.getId());
        if (!table.hasMetadata()) {
            return tableBuilder.build();
        }
        Stream<ObjectTypes.ContentPartReference> contentParts = Stream.concat(Stream.concat(table.getExtraPartsList().stream(), table.getCurrentPartsList().stream()), Stream.of(table.getMetadata()));
        ObjectNode metadata = TableCommitMetaStoreWorker.mergeAttachmentsIntoMetadata(attachmentsRetriever, content, contentParts);
        metadata.withArray("schemas");
        metadata.withArray("partition-specs");
        metadata.withArray("sort-orders");
        metadata.withArray("snapshots");
        return tableBuilder.metadata(GenericMetadata.of((String)"iceberg", (JsonNode)metadata)).build();
    }

    private static ObjectNode mergeAttachmentsIntoMetadata(Function<Stream<ContentAttachmentKey>, Stream<ContentAttachment>> attachmentsRetriever, ObjectTypes.Content content, Stream<ObjectTypes.ContentPartReference> contentParts) {
        Stream<ContentAttachmentKey> attachmentKeys = contentParts.map(partRef -> ContentAttachmentKey.of((String)content.getId(), (String)partRef.getType().name(), (String)partRef.getAttachmentId()));
        EnumMap nodesPerPartType = new EnumMap(ObjectTypes.ContentPartType.class);
        try (Stream<ContentAttachment> attachments = attachmentsRetriever.apply(attachmentKeys);){
            attachments.forEach(att -> {
                String type = att.getKey().getAttachmentType();
                ObjectTypes.ContentPartType partType = ObjectTypes.ContentPartType.valueOf((String)type);
                nodesPerPartType.computeIfAbsent(partType, x -> new ArrayList()).add(TableCommitMetaStoreWorker.fromBytesAsJson(att));
            });
        }
        ObjectNode metadata = (ObjectNode)((List)Preconditions.checkNotNull((Object)((List)nodesPerPartType.get(ObjectTypes.ContentPartType.SHALLOW_METADATA)), (String)"No attachment of type SHALLOW_METADATA for content ID '%s'", (Object)content.getId())).get(0);
        JSON_ARRAY_NAMES_FOR_PART_TYPE.forEach((type, jsonName) -> TableCommitMetaStoreWorker.addJsonArray((JsonNode)metadata, jsonName, (List)nodesPerPartType.get(type)));
        return metadata;
    }

    private static ImmutableIcebergView valueFromStoreIcebergView(Function<Stream<ContentAttachmentKey>, Stream<ContentAttachment>> attachmentsRetriever, ObjectTypes.Content content, Supplier<String> metadataPointerSupplier) {
        ObjectTypes.IcebergViewState view = content.getIcebergViewState();
        String metadataLocation = view.hasMetadataLocation() ? view.getMetadataLocation() : metadataPointerSupplier.get();
        ImmutableIcebergView.Builder viewBuilder = IcebergView.builder().metadataLocation(metadataLocation).versionId(view.getVersionId()).schemaId(view.getSchemaId()).dialect(view.getDialect()).sqlText(view.getSqlText()).id(content.getId());
        if (!view.hasMetadata()) {
            return viewBuilder.build();
        }
        Stream<ObjectTypes.ContentPartReference> contentParts = Stream.concat(Stream.of(view.getMetadata()), Stream.concat(view.getCurrentPartsList().stream(), view.getExtraPartsList().stream()));
        ObjectNode metadata = TableCommitMetaStoreWorker.mergeAttachmentsIntoMetadata(attachmentsRetriever, content, contentParts);
        metadata.withArray("versions");
        return viewBuilder.metadata(GenericMetadata.of((String)"iceberg", (JsonNode)metadata)).build();
    }

    private static void addJsonArray(JsonNode jsonNode, String fieldName, List<JsonNode> retrieved) {
        if (retrieved != null) {
            ArrayNode array = (ArrayNode)jsonNode.withArray(fieldName);
            array.addAll(retrieved);
        }
    }

    private static String hashForJson(JsonNode jsonNode) {
        Hasher h = Hashing.sha256().newHasher();
        TableCommitMetaStoreWorker.hashForJson(h, jsonNode);
        return h.hash().toString();
    }

    private static void hashForJson(Hasher h, JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case ARRAY: {
                jsonNode.elements().forEachRemaining(n -> TableCommitMetaStoreWorker.hashForJson(h, n));
                break;
            }
            case OBJECT: {
                jsonNode.fields().forEachRemaining(e -> {
                    h.putUnencodedChars((CharSequence)e.getKey());
                    TableCommitMetaStoreWorker.hashForJson(h, (JsonNode)e.getValue());
                });
                break;
            }
            case BINARY: {
                try {
                    h.putBytes(jsonNode.binaryValue());
                    break;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            case BOOLEAN: {
                h.putBoolean(jsonNode.booleanValue());
                break;
            }
            case NUMBER: {
                h.putLong(jsonNode.longValue());
                break;
            }
            case POJO: 
            case STRING: {
                h.putUnencodedChars((CharSequence)jsonNode.asText());
                break;
            }
            case MISSING: 
            case NULL: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unexpected node type '%s' in JSON node '%s'", jsonNode.getNodeType(), jsonNode));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ImmutableContentAttachment.Builder fromJson(ImmutableContentAttachment.Builder attachment, JsonNode jsonNode) {
        attachment.compression(ContentAttachment.Compression.NONE);
        switch (PREFERRED_ATTACHMENT_FORMAT) {
            case CBOR: {
                ImmutableContentAttachment.Builder builder;
                ByteString.Output out = ByteString.newOutput();
                try {
                    CBOR_MAPPER.writeValue((OutputStream)out, (Object)jsonNode);
                    ByteString data = out.toByteString();
                    builder = attachment.format(ContentAttachment.Format.CBOR).data(data);
                    if (out == null) return builder;
                }
                catch (Throwable throwable) {
                    try {
                        if (out == null) throw throwable;
                        try {
                            out.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                out.close();
                return builder;
            }
        }
        return attachment.format(ContentAttachment.Format.JSON).data(ByteString.copyFromUtf8((String)jsonNode.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ObjectNode fromBytesAsJson(ContentAttachment attachment) {
        try {
            switch (attachment.getFormat()) {
                case JSON: {
                    return (ObjectNode)MAPPER.readValue(attachment.getData().toStringUtf8(), JsonNode.class);
                }
                case CBOR: {
                    try (JsonParser parser = CBOR_MAPPER.createParser(attachment.getData().newInput());){
                        ObjectNode objectNode = (ObjectNode)parser.readValueAs(JsonNode.class);
                        return objectNode;
                    }
                }
            }
            throw new IllegalStateException(String.format("Format '%s' not supported", attachment.getFormat()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to deserialize attachment '%s'", attachment.getKey()), e);
        }
    }

    private static IllegalArgumentException noIcebergMetadataPointer() {
        return new IllegalArgumentException("Iceberg content from reference must have global state, but has none");
    }

    public Content applyId(Content content, String id) {
        Objects.requireNonNull(content, "content must not be null");
        Preconditions.checkArgument((content.getId() == null ? 1 : 0) != 0, (Object)"content.getId() must be null");
        Objects.requireNonNull(id, "id must not be null");
        if (content instanceof IcebergTable) {
            return IcebergTable.builder().from(content).id(id).build();
        }
        if (content instanceof DeltaLakeTable) {
            return ImmutableDeltaLakeTable.builder().from(content).id(id).build();
        }
        if (content instanceof IcebergView) {
            return IcebergView.builder().from(content).id(id).build();
        }
        if (content instanceof Namespace) {
            return ImmutableNamespace.builder().from(content).id(id).build();
        }
        throw new IllegalArgumentException("Unknown type " + content);
    }

    public String getId(Content content) {
        return content.getId();
    }

    public Byte getPayload(Content content) {
        if (content instanceof IcebergTable) {
            return (byte)Content.Type.ICEBERG_TABLE.ordinal();
        }
        if (content instanceof DeltaLakeTable) {
            return (byte)Content.Type.DELTA_LAKE_TABLE.ordinal();
        }
        if (content instanceof IcebergView) {
            return (byte)Content.Type.ICEBERG_VIEW.ordinal();
        }
        if (content instanceof Namespace) {
            return (byte)Content.Type.NAMESPACE.ordinal();
        }
        throw new IllegalArgumentException("Unknown type " + content);
    }

    public Content.Type getType(Content content) {
        return content.getType();
    }

    public Content.Type getType(Byte payload) {
        if (payload == null || payload > Content.Type.values().length || payload < 0) {
            throw new IllegalArgumentException(String.format("Cannot create type from payload. Payload %d does not exist", payload));
        }
        return Content.Type.values()[payload];
    }

    public Content.Type getType(ByteString onRefContent) {
        ObjectTypes.Content parsed = TableCommitMetaStoreWorker.parse(onRefContent);
        if (parsed.hasIcebergRefState()) {
            return Content.Type.ICEBERG_TABLE;
        }
        if (parsed.hasIcebergViewState()) {
            return Content.Type.ICEBERG_VIEW;
        }
        if (parsed.hasDeltaLakeTable()) {
            return Content.Type.DELTA_LAKE_TABLE;
        }
        if (parsed.hasNamespace()) {
            return Content.Type.NAMESPACE;
        }
        throw new IllegalArgumentException("Unsupported on-ref content " + parsed);
    }

    public boolean requiresGlobalState(Content content) {
        switch (content.getType()) {
            default: 
        }
        return false;
    }

    public boolean requiresGlobalState(ByteString content) {
        ObjectTypes.Content parsed = TableCommitMetaStoreWorker.parse(content);
        switch (parsed.getObjectTypeCase()) {
            case ICEBERG_REF_STATE: {
                return !parsed.getIcebergRefState().hasMetadataLocation();
            }
            case ICEBERG_VIEW_STATE: {
                return !parsed.getIcebergViewState().hasMetadataLocation();
            }
        }
        return false;
    }

    private static ObjectTypes.Content parse(ByteString value) {
        try {
            return ObjectTypes.Content.parseFrom((ByteString)value);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failure parsing data", e);
        }
    }

    public Serializer<CommitMeta> getMetadataSerializer() {
        return this.metaSerializer;
    }

    public boolean isNamespace(ByteString type) {
        try {
            return Content.Type.NAMESPACE == this.getType(type);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        JSON_ARRAY_NAMES_FOR_PART_TYPE.put(ObjectTypes.ContentPartType.PARTITION_SPEC, "partition-specs");
        JSON_ARRAY_NAMES_FOR_PART_TYPE.put(ObjectTypes.ContentPartType.SNAPSHOT, "snapshots");
        JSON_ARRAY_NAMES_FOR_PART_TYPE.put(ObjectTypes.ContentPartType.SCHEMA, "schemas");
        JSON_ARRAY_NAMES_FOR_PART_TYPE.put(ObjectTypes.ContentPartType.SORT_ORDER, "sort-orders");
        JSON_ARRAY_NAMES_FOR_PART_TYPE.put(ObjectTypes.ContentPartType.VERSION, "versions");
        ICEBERG_ATTACHMENT_DEFS = Arrays.asList(new IcebergAttachmentDefinition(ObjectTypes.ContentPartType.SNAPSHOT, "snapshots", "current-snapshot-id", "snapshot-id", false), new IcebergAttachmentDefinition(ObjectTypes.ContentPartType.SCHEMA, "schemas", "current-schema-id", "schema-id", true), new IcebergAttachmentDefinition(ObjectTypes.ContentPartType.SORT_ORDER, "sort-orders", "default-sort-order-id", "order-id", true), new IcebergAttachmentDefinition(ObjectTypes.ContentPartType.PARTITION_SPEC, "partition-specs", "default-spec-id", "spec-id", true), new IcebergAttachmentDefinition(ObjectTypes.ContentPartType.VERSION, "versions", "current-version-id", "version-id", false));
    }

    private static class MetadataSerializer
    implements Serializer<CommitMeta> {
        private MetadataSerializer() {
        }

        public ByteString toBytes(CommitMeta value) {
            try {
                return ByteString.copyFrom((byte[])MAPPER.writeValueAsBytes((Object)value));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Couldn't serialize commit meta %s", value), e);
            }
        }

        public CommitMeta fromBytes(ByteString bytes) {
            try {
                return (CommitMeta)MAPPER.readValue(bytes.toByteArray(), CommitMeta.class);
            }
            catch (IOException e) {
                return ImmutableCommitMeta.builder().message("unknown").committer("unknown").hash("unknown").build();
            }
        }
    }

    private static final class IcebergAttachmentDefinition {
        final ObjectTypes.ContentPartType contentPartType;
        final String metadataContainerField;
        final String metadataIdRefField;
        final String childIdField;
        final boolean retainAllAsCurrent;

        IcebergAttachmentDefinition(ObjectTypes.ContentPartType contentPartType, String metadataContainerField, String metadataIdRefField, String childIdField, boolean retainAllAsCurrent) {
            this.contentPartType = contentPartType;
            this.metadataContainerField = metadataContainerField;
            this.metadataIdRefField = metadataIdRefField;
            this.childIdField = childIdField;
            this.retainAllAsCurrent = retainAllAsCurrent;
        }
    }
}

