/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import com.google.protobuf.ByteString;
import java.util.function.Supplier;
import org.projectnessie.model.Content;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.server.store.BaseSerializer;
import org.projectnessie.server.store.proto.ObjectTypes;

public final class DeltaLakeTableSerializer
extends BaseSerializer<DeltaLakeTable> {
    public Content.Type contentType() {
        return Content.Type.DELTA_LAKE_TABLE;
    }

    public byte payload() {
        return 2;
    }

    @Override
    protected void toStoreOnRefState(DeltaLakeTable content, ObjectTypes.Content.Builder builder) {
        ObjectTypes.DeltaLakeTable.Builder table = ObjectTypes.DeltaLakeTable.newBuilder().addAllMetadataLocationHistory((Iterable)content.getMetadataLocationHistory()).addAllCheckpointLocationHistory((Iterable)content.getCheckpointLocationHistory());
        String lastCheckpoint = content.getLastCheckpoint();
        if (lastCheckpoint != null) {
            table.setLastCheckpoint(lastCheckpoint);
        }
        builder.setDeltaLakeTable(table);
    }

    public DeltaLakeTable applyId(DeltaLakeTable content, String id) {
        return ImmutableDeltaLakeTable.builder().from(content).id(id).build();
    }

    @Override
    protected DeltaLakeTable valueFromStore(ObjectTypes.Content content, Supplier<ByteString> globalState) {
        return DeltaLakeTableSerializer.valueFromStoreDeltaLakeTable(content);
    }
}

