/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableHiveDatabase;
import org.projectnessie.model.ImmutableHiveTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.SqlView;
import org.projectnessie.server.store.TableCommitMetaStoreWorker;
import org.projectnessie.store.ObjectTypes;

class TestStoreWorker {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String ID = "x";
    private final TableCommitMetaStoreWorker worker = new TableCommitMetaStoreWorker();

    TestStoreWorker() {
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testDeserialization(Map.Entry<ByteString, Contents> entry) {
        Contents actual = (Contents)this.worker.getValueSerializer().fromBytes(entry.getKey());
        Assertions.assertEquals((Object)entry.getValue(), (Object)actual);
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testSerialization(Map.Entry<ByteString, Contents> entry) {
        ByteString actual = this.worker.getValueSerializer().toBytes((Object)entry.getValue());
        Assertions.assertEquals((Object)entry.getKey(), (Object)actual);
    }

    @ParameterizedTest
    @MethodSource(value={"provideDeserialization"})
    void testSerde(Map.Entry<ByteString, Contents> entry) {
        ByteString actualBytes = this.worker.getValueSerializer().toBytes((Object)entry.getValue());
        Assertions.assertEquals((Object)entry.getValue(), (Object)this.worker.getValueSerializer().fromBytes(actualBytes));
        Contents actualContents = (Contents)this.worker.getValueSerializer().fromBytes(entry.getKey());
        Assertions.assertEquals((Object)entry.getKey(), (Object)this.worker.getValueSerializer().toBytes((Object)actualContents));
    }

    @Test
    void testCommitSerde() throws JsonProcessingException {
        ImmutableCommitMeta expectedCommit = ImmutableCommitMeta.builder().commitTime(Instant.now()).authorTime(Instant.now()).author("bill").committer("ted").hash("xyz").message("commit msg").build();
        ByteString expectedBytes = ByteString.copyFrom((byte[])MAPPER.writeValueAsBytes((Object)expectedCommit));
        CommitMeta actualCommit = (CommitMeta)this.worker.getMetadataSerializer().fromBytes(expectedBytes);
        Assertions.assertEquals((Object)expectedCommit, (Object)actualCommit);
        ByteString actualBytes = this.worker.getMetadataSerializer().toBytes((Object)expectedCommit);
        Assertions.assertEquals((Object)expectedBytes, (Object)actualBytes);
        actualBytes = this.worker.getMetadataSerializer().toBytes((Object)expectedCommit);
        Assertions.assertEquals((Object)expectedCommit, (Object)this.worker.getMetadataSerializer().fromBytes(actualBytes));
        actualCommit = (CommitMeta)this.worker.getMetadataSerializer().fromBytes(expectedBytes);
        Assertions.assertEquals((Object)expectedBytes, (Object)this.worker.getMetadataSerializer().toBytes((Object)actualCommit));
    }

    private static Stream<Map.Entry<ByteString, Contents>> provideDeserialization() {
        return Stream.of(TestStoreWorker.getIceberg(), TestStoreWorker.getHiveDb(), TestStoreWorker.getHiveTable(), TestStoreWorker.getDelta(), TestStoreWorker.getView());
    }

    private static Map.Entry<ByteString, Contents> getIceberg() {
        String path = "foo/bar";
        ImmutableIcebergTable contents = ImmutableIcebergTable.builder().metadataLocation(path).id(ID).build();
        ByteString bytes = ObjectTypes.Contents.newBuilder().setId(ID).setIcebergTable(ObjectTypes.IcebergTable.newBuilder().setMetadataLocation(path)).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, ImmutableIcebergTable>(bytes, contents);
    }

    private static Map.Entry<ByteString, Contents> getHiveDb() {
        byte[] database = new byte[]{0, 1, 2, 3, 4, 5};
        ImmutableHiveDatabase contents = ImmutableHiveDatabase.builder().databaseDefinition(database).id(ID).build();
        ByteString bytes = ObjectTypes.Contents.newBuilder().setId(ID).setHiveDatabase(ObjectTypes.HiveDatabase.newBuilder().setDatabase(ByteString.copyFrom((byte[])database))).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, ImmutableHiveDatabase>(bytes, contents);
    }

    private static Map.Entry<ByteString, Contents> getHiveTable() {
        byte[] table = new byte[]{0, 1, 2, 3, 4, 5};
        byte[][] partitions = new byte[][]{{0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 5}};
        List partitionsBytes = Arrays.stream(partitions).map(ByteString::copyFrom).collect(Collectors.toList());
        ImmutableHiveTable contents = ImmutableHiveTable.builder().tableDefinition(table).addPartitions((byte[][])partitions).id(ID).build();
        ByteString bytes = ObjectTypes.Contents.newBuilder().setId(ID).setHiveTable(ObjectTypes.HiveTable.newBuilder().setTable(ByteString.copyFrom((byte[])table)).addAllPartition(partitionsBytes)).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, ImmutableHiveTable>(bytes, contents);
    }

    private static Map.Entry<ByteString, Contents> getDelta() {
        String path = "foo/bar";
        String cl1 = "xyz";
        String cl2 = "abc";
        String ml1 = "efg";
        String ml2 = "hij";
        ImmutableDeltaLakeTable contents = ImmutableDeltaLakeTable.builder().lastCheckpoint(path).addCheckpointLocationHistory(cl1).addCheckpointLocationHistory(cl2).addMetadataLocationHistory(ml1).addMetadataLocationHistory(ml2).id(ID).build();
        ByteString bytes = ObjectTypes.Contents.newBuilder().setId(ID).setDeltaLakeTable(ObjectTypes.DeltaLakeTable.newBuilder().setLastCheckpoint(path).addCheckpointLocationHistory(cl1).addCheckpointLocationHistory(cl2).addMetadataLocationHistory(ml1).addMetadataLocationHistory(ml2)).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, ImmutableDeltaLakeTable>(bytes, contents);
    }

    private static Map.Entry<ByteString, Contents> getView() {
        String path = "SELECT * FROM foo.bar,";
        ImmutableSqlView contents = ImmutableSqlView.builder().dialect(SqlView.Dialect.DREMIO).sqlText(path).id(ID).build();
        ByteString bytes = ObjectTypes.Contents.newBuilder().setId(ID).setSqlView(ObjectTypes.SqlView.newBuilder().setSqlText(path).setDialect("DREMIO")).build().toByteString();
        return new AbstractMap.SimpleImmutableEntry<ByteString, ImmutableSqlView>(bytes, contents);
    }
}

