/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.server.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.util.stream.Collectors;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.HiveDatabase;
import org.projectnessie.model.HiveTable;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableHiveDatabase;
import org.projectnessie.model.ImmutableHiveTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.SqlView;
import org.projectnessie.store.ObjectTypes;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.SerializerWithPayload;
import org.projectnessie.versioned.StoreWorker;

public class TableCommitMetaStoreWorker
implements StoreWorker<Contents, CommitMeta, Contents.Type> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final SerializerWithPayload<Contents, Contents.Type> tableSerializer = new TableValueSerializer();
    private final Serializer<CommitMeta> metaSerializer = new MetadataSerializer();

    public SerializerWithPayload<Contents, Contents.Type> getValueSerializer() {
        return this.tableSerializer;
    }

    public Serializer<CommitMeta> getMetadataSerializer() {
        return this.metaSerializer;
    }

    private static class MetadataSerializer
    implements Serializer<CommitMeta> {
        private MetadataSerializer() {
        }

        public ByteString toBytes(CommitMeta value) {
            try {
                return ByteString.copyFrom((byte[])MAPPER.writeValueAsBytes((Object)value));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Couldn't serialize commit meta %s", value), e);
            }
        }

        public CommitMeta fromBytes(ByteString bytes) {
            try {
                return (CommitMeta)MAPPER.readValue(bytes.toByteArray(), CommitMeta.class);
            }
            catch (IOException e) {
                return ImmutableCommitMeta.builder().message("unknown").committer("unknown").hash("unknown").build();
            }
        }
    }

    private static class TableValueSerializer
    implements SerializerWithPayload<Contents, Contents.Type> {
        private TableValueSerializer() {
        }

        public ByteString toBytes(Contents value) {
            ObjectTypes.Contents.Builder builder = ObjectTypes.Contents.newBuilder().setId(value.getId());
            if (value instanceof IcebergTable) {
                builder.setIcebergTable(ObjectTypes.IcebergTable.newBuilder().setMetadataLocation(((IcebergTable)value).getMetadataLocation()));
            } else if (value instanceof DeltaLakeTable) {
                ObjectTypes.DeltaLakeTable.Builder table = ObjectTypes.DeltaLakeTable.newBuilder().addAllMetadataLocationHistory(((DeltaLakeTable)value).getMetadataLocationHistory()).addAllCheckpointLocationHistory(((DeltaLakeTable)value).getCheckpointLocationHistory());
                String lastCheckpoint = ((DeltaLakeTable)value).getLastCheckpoint();
                if (lastCheckpoint != null) {
                    table.setLastCheckpoint(lastCheckpoint);
                }
                builder.setDeltaLakeTable(table);
            } else if (value instanceof HiveTable) {
                HiveTable ht = (HiveTable)value;
                builder.setHiveTable(ObjectTypes.HiveTable.newBuilder().setTable(UnsafeByteOperations.unsafeWrap((byte[])ht.getTableDefinition())).addAllPartition(ht.getPartitions().stream().map(UnsafeByteOperations::unsafeWrap).collect(Collectors.toList())));
            } else if (value instanceof HiveDatabase) {
                builder.setHiveDatabase(ObjectTypes.HiveDatabase.newBuilder().setDatabase(UnsafeByteOperations.unsafeWrap((byte[])((HiveDatabase)value).getDatabaseDefinition())));
            } else if (value instanceof SqlView) {
                SqlView view = (SqlView)value;
                builder.setSqlView(ObjectTypes.SqlView.newBuilder().setDialect(view.getDialect().name()).setSqlText(view.getSqlText()));
            } else {
                throw new IllegalArgumentException("Unknown type" + value);
            }
            return builder.build().toByteString();
        }

        public Contents fromBytes(ByteString bytes) {
            ObjectTypes.Contents contents;
            try {
                contents = ObjectTypes.Contents.parseFrom(bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Failure parsing data", e);
            }
            switch (contents.getObjectTypeCase()) {
                case DELTA_LAKE_TABLE: {
                    ImmutableDeltaLakeTable.Builder builder = ImmutableDeltaLakeTable.builder().id(contents.getId()).addAllMetadataLocationHistory((Iterable)contents.getDeltaLakeTable().getMetadataLocationHistoryList()).addAllCheckpointLocationHistory((Iterable)contents.getDeltaLakeTable().getCheckpointLocationHistoryList());
                    if (contents.getDeltaLakeTable().getLastCheckpoint() != null) {
                        builder.lastCheckpoint(contents.getDeltaLakeTable().getLastCheckpoint());
                    }
                    return builder.build();
                }
                case HIVE_DATABASE: {
                    return ImmutableHiveDatabase.builder().id(contents.getId()).databaseDefinition(contents.getHiveDatabase().getDatabase().toByteArray()).build();
                }
                case HIVE_TABLE: {
                    return ImmutableHiveTable.builder().id(contents.getId()).addAllPartitions((Iterable)contents.getHiveTable().getPartitionList().stream().map(ByteString::toByteArray).collect(Collectors.toList())).tableDefinition(contents.getHiveTable().getTable().toByteArray()).build();
                }
                case ICEBERG_TABLE: {
                    return ImmutableIcebergTable.builder().metadataLocation(contents.getIcebergTable().getMetadataLocation()).id(contents.getId()).build();
                }
                case SQL_VIEW: {
                    ObjectTypes.SqlView view = contents.getSqlView();
                    return ImmutableSqlView.builder().dialect(SqlView.Dialect.valueOf((String)view.getDialect())).sqlText(view.getSqlText()).id(contents.getId()).build();
                }
            }
            throw new IllegalArgumentException("Unknown type" + (Object)((Object)contents.getObjectTypeCase()));
        }

        public Byte getPayload(Contents value) {
            if (value instanceof IcebergTable) {
                return (byte)Contents.Type.ICEBERG_TABLE.ordinal();
            }
            if (value instanceof DeltaLakeTable) {
                return (byte)Contents.Type.DELTA_LAKE_TABLE.ordinal();
            }
            if (value instanceof HiveTable) {
                return (byte)Contents.Type.HIVE_TABLE.ordinal();
            }
            if (value instanceof HiveDatabase) {
                return (byte)Contents.Type.HIVE_DATABASE.ordinal();
            }
            if (value instanceof SqlView) {
                return (byte)Contents.Type.VIEW.ordinal();
            }
            throw new IllegalArgumentException("Unknown type" + value);
        }

        public Contents.Type getType(Byte payload) {
            if (payload == null || payload > Contents.Type.values().length || payload < 0) {
                throw new IllegalArgumentException(String.format("Cannot create type from payload. Payload %d does not exist", payload));
            }
            return Contents.Type.values()[payload];
        }
    }
}

