/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.OptionalInt;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ImmutableBranch;
import org.projectnessie.model.ImmutableTag;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class NessieUtils$ {
    public static NessieUtils$ MODULE$;
    private final String BRANCH;
    private final String TAG;
    private final String HASH;

    static {
        new NessieUtils$();
    }

    public String BRANCH() {
        return this.BRANCH;
    }

    public String TAG() {
        return this.TAG;
    }

    public String HASH() {
        return this.HASH;
    }

    public Reference calculateRef(String branch, Option<String> tsOrHash, NessieApiV1 api) {
        String hash = (String)tsOrHash.map((Function1 & Serializable & scala.Serializable)x -> x.replaceAll("`", "")).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieUtils$.$anonfun$calculateRef$2(x))).orNull(Predef$.MODULE$.$conforms());
        if (hash != null) {
            return this.findReferenceFromHash(branch, hash, api);
        }
        Instant timestamp = (Instant)tsOrHash.map((Function1 & Serializable & scala.Serializable)x -> x.replaceAll("`", "")).map((Function1 & Serializable & scala.Serializable)x -> {
            Instant instant;
            try {
                instant = LocalDateTime.parse(x).atZone(ZoneOffset.UTC).toInstant();
            }
            catch (DateTimeParseException e) {
                throw new NessieNotFoundException(new StringBuilder(28).append("Invalid timestamp provided: ").append(e.getMessage()).toString());
            }
            return instant;
        }).orNull(Predef$.MODULE$.$conforms());
        return timestamp == null ? api.getReference().refName(branch).get() : this.findReferenceFromTimestamp(branch, api, timestamp);
    }

    private Reference findReferenceFromHash(String branch, String requestedHash, NessieApiV1 api) {
        String value;
        Option commit = Option$.MODULE$.apply(StreamingUtil.getCommitLogStream((NessieApiV1)api, (String)branch, (String)Validation.validateHash((String)requestedHash), null, null, (OptionalInt)OptionalInt.empty()).findFirst().orElse(null)).map((Function1 & Serializable & scala.Serializable)x -> x.getCommitMeta().getHash());
        Option option = commit;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NessieNotFoundException(String.format("Cannot find requested hash %s on reference %s.", requestedHash, branch));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String string = value = (String)some.value();
        String hash = string;
        return this.convertToSpecificRef(hash, api.getReference().refName(branch).get());
    }

    private Reference findReferenceFromTimestamp(String branch, NessieApiV1 api, Instant timestamp) {
        String value;
        Option commit = Option$.MODULE$.apply(StreamingUtil.getCommitLogStream((NessieApiV1)api, (String)branch, null, null, (String)String.format("timestamp(commit.commitTime) < timestamp('%s')", timestamp), (OptionalInt)OptionalInt.empty()).findFirst().orElse(null)).map((Function1 & Serializable & scala.Serializable)x -> x.getCommitMeta().getHash());
        Option option = commit;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NessieNotFoundException(String.format("Cannot find a hash before %s.", timestamp));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String string = value = (String)some.value();
        String hash = string;
        return this.convertToSpecificRef(hash, api.getReference().refName(branch).get());
    }

    private Reference convertToSpecificRef(String hash, Reference reference) {
        Branch branch;
        Reference reference2 = reference;
        if (reference2 instanceof ImmutableBranch) {
            ImmutableBranch immutableBranch = (ImmutableBranch)reference2;
            branch = Branch.of((String)immutableBranch.getName(), (String)hash);
        } else if (reference2 instanceof ImmutableTag) {
            ImmutableTag immutableTag = (ImmutableTag)reference2;
            branch = Tag.of((String)immutableTag.getName(), (String)hash);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(23).append("Unknown reference type ").append(reference).toString());
        }
        return branch;
    }

    public NessieApiV1 nessieAPI(CatalogPlugin currentCatalog, Option<String> catalog) {
        scala.collection.immutable.Map catalogConf;
        block4: {
            String string;
            String catalogName = (String)catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> currentCatalog.name());
            SparkConf sparkConf = SparkSession$.MODULE$.active().sparkContext().conf();
            catalogConf = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(new StringBuilder(19).append("spark.sql.catalog.").append(catalogName).append(".").toString()))).toMap(Predef$.MODULE$.$conforms());
            Option catalogClass = sparkConf.getOption(new StringBuilder(18).append("spark.sql.catalog.").append(catalogName).toString());
            boolean needsImplCheck = BoxesRunTime.unboxToBoolean((Object)catalogClass.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NessieUtils$.$anonfun$nessieAPI$2(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
            if (!needsImplCheck) break block4;
            Option catalogImpl = catalogConf.get((Object)"catalog-impl");
            Option option = catalogImpl;
            if (option instanceof Some) {
                Some some = (Some)option;
                String clazz = (String)some.value();
                string = new StringBuilder(10).append("but ").append(catalogName).append(" is a ").append(clazz).toString();
            } else if (None$.MODULE$.equals(option)) {
                string = new StringBuilder(46).append("but spark.sql.catalog.").append(catalogName).append(".catalog-impl is not set").toString();
            } else {
                throw new MatchError((Object)option);
            }
            String catalogErrorDetail = string;
            Predef$.MODULE$.require(catalogImpl.exists((Function1 & Serializable & scala.Serializable)impl -> BoxesRunTime.boxToBoolean((boolean)impl.endsWith(".NessieCatalog"))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(178).append("The command works only when the catalog is a NessieCatalog (").append(catalogErrorDetail).append("). Either set the catalog via USE <catalog_name> or provide the catalog during execution: <command> IN <catalog_name>.").toString());
        }
        return (NessieApiV1)HttpClientBuilder.builder().fromConfig(x -> (String)catalogConf.getOrElse((Object)x.replace("nessie.", ""), (Function0 & Serializable & scala.Serializable)() -> null)).build(NessieApiV1.class);
    }

    public void setCurrentRefForSpark(CatalogPlugin currentCatalog, Option<String> catalog, Reference ref) {
        String catalogName = (String)catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> currentCatalog.name());
        CatalogPlugin catalogImpl = SparkSession$.MODULE$.active().sessionState().catalogManager().catalog(catalogName);
        SparkSession$.MODULE$.active().sparkContext().conf().set(new StringBuilder(22).append("spark.sql.catalog.").append(catalogName).append(".ref").toString(), ref.getName());
        SparkSession$.MODULE$.active().sparkContext().conf().set(new StringBuilder(27).append("spark.sql.catalog.").append(catalogName).append(".ref.hash").toString(), ref.getHash());
        java.util.Map catalogConf = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkSession$.MODULE$.active().sparkContext().conf().getAllWithPrefix(new StringBuilder(19).append("spark.sql.catalog.").append(catalogName).append(".").toString()))).toMap(Predef$.MODULE$.$conforms())).asJava();
        catalogImpl.initialize(catalogName, new CaseInsensitiveStringMap(catalogConf));
    }

    public Reference getCurrentRef(CatalogPlugin currentCatalog, Option<String> catalog) {
        String catalogName = (String)catalog.getOrElse((Function0 & Serializable & scala.Serializable)() -> currentCatalog.name());
        String refName = SparkSession$.MODULE$.active().sparkContext().conf().get(new StringBuilder(22).append("spark.sql.catalog.").append(catalogName).append(".ref").toString());
        return this.nessieAPI(currentCatalog, catalog).getReference().refName(refName).get();
    }

    public String getRefType(Reference ref) {
        String string;
        Reference reference = ref;
        if (reference instanceof ImmutableBranch) {
            string = this.BRANCH();
        } else if (reference instanceof ImmutableTag) {
            string = this.TAG();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(23).append("Unknown reference type ").append(ref).toString());
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$calculateRef$2(String x) {
        return Validation.isValidHash((String)x);
    }

    public static final /* synthetic */ boolean $anonfun$nessieAPI$2(String x$1) {
        return !x$1.endsWith(".DeltaCatalog");
    }

    private NessieUtils$() {
        MODULE$ = this;
        this.BRANCH = "Branch";
        this.TAG = "Tag";
        this.HASH = "Hash";
    }
}

