/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.PagingBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.RefLogResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;

public final class StreamingUtil {
    private StreamingUtil() {
    }

    public static Stream<Reference> getAllReferencesStream(@NotNull NessieApiV1 api, @NotNull Function<GetAllReferencesBuilder, GetAllReferencesBuilder> builderCustomizer, @NotNull OptionalInt maxRecords) throws NessieNotFoundException {
        return new ResultStreamPaginator(ReferencesResponse::getReferences, (pageSize, token) -> {
            GetAllReferencesBuilder builder = (GetAllReferencesBuilder)builderCustomizer.apply(api.getAllReferences());
            return StreamingUtil.builderWithPaging(builder, pageSize, token).get();
        }).generateStream(maxRecords);
    }

    public static Stream<EntriesResponse.Entry> getEntriesStream(@NotNull NessieApiV1 api, @NotNull Function<GetEntriesBuilder, GetEntriesBuilder> builderCustomizer, @NotNull OptionalInt maxRecords) throws NessieNotFoundException {
        return new ResultStreamPaginator(EntriesResponse::getEntries, (pageSize, token) -> {
            GetEntriesBuilder builder = (GetEntriesBuilder)builderCustomizer.apply(api.getEntries());
            return StreamingUtil.builderWithPaging(builder, pageSize, token).get();
        }).generateStream(maxRecords);
    }

    public static Stream<LogResponse.LogEntry> getCommitLogStream(@NotNull NessieApiV1 api, @NotNull Function<GetCommitLogBuilder, GetCommitLogBuilder> builderCustomizer, @NotNull OptionalInt maxRecords) throws NessieNotFoundException {
        return new ResultStreamPaginator(LogResponse::getLogEntries, (pageSize, token) -> {
            GetCommitLogBuilder builder = (GetCommitLogBuilder)builderCustomizer.apply(api.getCommitLog());
            return StreamingUtil.builderWithPaging(builder, pageSize, token).get();
        }).generateStream(maxRecords);
    }

    public static Stream<RefLogResponse.RefLogResponseEntry> getReflogStream(@NotNull NessieApiV1 api, @NotNull Function<GetRefLogBuilder, GetRefLogBuilder> builderCustomizer, @NotNull OptionalInt maxRecords) throws NessieNotFoundException {
        return new ResultStreamPaginator(RefLogResponse::getLogEntries, (pageSize, token) -> {
            GetRefLogBuilder builder = (GetRefLogBuilder)builderCustomizer.apply(api.getRefLog());
            return StreamingUtil.builderWithPaging(builder, pageSize, token).get();
        }).generateStream(maxRecords);
    }

    private static <B extends PagingBuilder<B>> B builderWithPaging(B builder, Integer pageSize, String token) {
        if (pageSize != null) {
            builder.maxRecords(pageSize);
        }
        if (token != null) {
            builder.pageToken(token);
        }
        return builder;
    }
}

