/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api;

import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.api.params.GetReferenceParams;
import org.projectnessie.api.params.ReferencesParams;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Transplant;

public interface TreeApi {
    public ReferencesResponse getAllReferences(ReferencesParams var1);

    public Branch getDefaultBranch() throws NessieNotFoundException;

    public Reference createReference(@Valid @Nullable @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @NotNull Reference var2) throws NessieNotFoundException, NessieConflictException;

    public Reference getReferenceByName(@Valid @NotNull GetReferenceParams var1) throws NessieNotFoundException;

    public EntriesResponse getEntries(@Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @NotNull EntriesParams var2) throws NessieNotFoundException;

    public LogResponse getCommitLog(@Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @NotNull CommitLogParams var2) throws NessieNotFoundException;

    public void assignReference(@Valid @NotNull Reference.ReferenceType var1, @Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var2, @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String var3, @Valid @NotNull Reference var4) throws NessieNotFoundException, NessieConflictException;

    public void deleteReference(@Valid @NotNull Reference.ReferenceType var1, @Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var2, @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String var3) throws NessieConflictException, NessieNotFoundException;

    public MergeResponse transplantCommitsIntoBranch(@Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String var2, @Valid String var3, @Valid Transplant var4) throws NessieNotFoundException, NessieConflictException;

    public MergeResponse mergeRefIntoBranch(@Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String var2, @Valid @NotNull Merge var3) throws NessieNotFoundException, NessieConflictException;

    public Branch commitMultipleOperations(@Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") @Valid @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String var1, @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") @Valid @NotNull @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String var2, @Valid @NotNull Operations var3) throws NessieNotFoundException, NessieConflictException;
}

