/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.http;

import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.projectnessie.api.TreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.api.params.GetReferenceParams;
import org.projectnessie.api.params.ReferencesParams;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Transplant;

@Consumes(value={"application/json"})
@Path(value="trees")
public interface HttpTreeApi
extends TreeApi {
    @Override
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all references")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned references.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="referencesResponse"), @ExampleObject(ref="referencesResponseWithMetadata")}, schema=@Schema(implementation=ReferencesResponse.class))}), @APIResponse(responseCode="401", description="Invalid credentials provided")})
    public ReferencesResponse getAllReferences(@BeanParam ReferencesParams var1);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="tree")
    @Operation(summary="Get default branch for commits and reads")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returns name and latest hash of the default branch.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="refObj")}, schema=@Schema(implementation=Branch.class))}), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="404", description="Default branch not found.")})
    public Branch getDefaultBranch() throws NessieNotFoundException;

    @Override
    @POST
    @Produces(value={"application/json"})
    @Path(value="tree")
    @Operation(summary="Create a new reference", description="The type of 'refObj', which can be either a 'Branch' or 'Tag', determines the type of the reference to be created.\n\n'Reference.name' defines the the name of the reference to be created,'Reference.hash' is the hash of the created reference, the HEAD of the created reference. 'sourceRefName' is the name of the reference which contains 'Reference.hash', and must be present if 'Reference.hash' is present.\n\nSpecifying no 'Reference.hash' means that the new reference will be created \"at the beginning of time\".")
    @APIResponses(value={@APIResponse(responseCode="200", description="Created successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="refObjNew")}, schema=@Schema(implementation=Reference.class))}), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to create reference"), @APIResponse(responseCode="409", description="Reference already exists")})
    public Reference createReference(@Parameter(description="Source named reference") @QueryParam(value="sourceRefName") String var1, @RequestBody(description="Reference to create.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="refObjNew")})}) Reference var2) throws NessieNotFoundException, NessieConflictException;

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="tree/{ref}")
    @Operation(summary="Fetch details of a reference")
    @APIResponses(value={@APIResponse(responseCode="200", description="Found and returned reference.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="refObj")}, schema=@Schema(implementation=Reference.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference"), @APIResponse(responseCode="404", description="Ref not found")})
    public Reference getReferenceByName(@BeanParam GetReferenceParams var1) throws NessieNotFoundException;

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="tree/{ref}/entries")
    @Operation(summary="Fetch all entries for a given reference", description="Retrieves objects for a ref, potentially truncated by the backend.\n\nRetrieves up to 'maxRecords' entries for the given named reference (tag or branch) or the given hash. The backend may respect the given 'max' records hint, but return less or more entries. Backends may also cap the returned entries at a hard-coded limit, the default REST server implementation has such a hard-coded limit.\n\nTo implement paging, check 'hasMore' in the response and, if 'true', pass the value returned as 'token' in the next invocation as the 'pageToken' parameter.\n\nThe content and meaning of the returned 'token' is \"private\" to the implementation,treat is as an opaque value.\n\nIt is wrong to assume that invoking this method with a very high 'maxRecords' value will return all commit log entries.\n\nThe 'filter' parameter allows for advanced filtering capabilities using the Common Expression Language (CEL).\nAn intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\n\nThe 'namespaceDepth' parameter returns only the ContentKey components up to the depth of 'namespaceDepth'.\nFor example they key 'a.b.c.d' with a depth of 3 will return 'a.b.c'. The operation is guaranteed to not return \nduplicates and therefore will never page.")
    @APIResponses(value={@APIResponse(description="all objects for a reference", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="entriesResponse")}, schema=@Schema(implementation=EntriesResponse.class))}), @APIResponse(responseCode="200", description="Returned successfully."), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or fetch entries for it"), @APIResponse(responseCode="404", description="Ref not found")})
    public EntriesResponse getEntries(@Parameter(description="name of ref to fetch from", examples={@ExampleObject(ref="ref")}) @PathParam(value="ref") String var1, @BeanParam EntriesParams var2) throws NessieNotFoundException;

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="tree/{ref}/log")
    @Operation(summary="Get commit log for a reference", description="Retrieve the commit log for a ref, potentially truncated by the backend.\n\nRetrieves up to 'maxRecords' commit-log-entries starting at the HEAD of the given named reference (tag or branch) or the given hash. The backend may respect the given 'max' records hint, but return less or more entries. Backends may also cap the returned entries at a hard-coded limit, the default REST server implementation has such a hard-coded limit.\n\nTo implement paging, check 'hasMore' in the response and, if 'true', pass the value returned as 'token' in the next invocation as the 'pageToken' parameter.\n\nThe content and meaning of the returned 'token' is \"private\" to the implementation,treat is as an opaque value.\n\nIt is wrong to assume that invoking this method with a very high 'maxRecords' value will return all commit log entries.\n\nThe 'filter' parameter allows for advanced filtering capabilities using the Common Expression Language (CEL).\nAn intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned commits.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="logResponseAdditionalInfo"), @ExampleObject(ref="logResponseSimple")}, schema=@Schema(implementation=LogResponse.class))}), @APIResponse(responseCode="400", description="Invalid input, ref name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or get commit log for it"), @APIResponse(responseCode="404", description="Ref doesn't exists")})
    public LogResponse getCommitLog(@Parameter(description="ref to show log from", examples={@ExampleObject(ref="ref")}) @PathParam(value="ref") String var1, @BeanParam CommitLogParams var2) throws NessieNotFoundException;

    @Override
    @PUT
    @Path(value="{referenceType}/{referenceName}")
    @Operation(summary="Set a named reference to a specific hash via a named-reference.", description="This operation takes the name of the named reference to reassign and the hash and the name of a named-reference via which the caller has access to that hash.")
    @APIResponses(value={@APIResponse(responseCode="204", description="Assigned successfully"), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view or assign reference"), @APIResponse(responseCode="404", description="One or more references don't exist"), @APIResponse(responseCode="409", description="Update conflict")})
    public void assignReference(@Parameter(description="Reference type to reassign", examples={@ExampleObject(ref="referenceType")}) @PathParam(value="referenceType") Reference.ReferenceType var1, @Parameter(description="Reference name to reassign", examples={@ExampleObject(ref="ref")}) @PathParam(value="referenceName") String var2, @Parameter(description="Expected previous hash of reference", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") String var3, @RequestBody(description="Reference hash to which 'referenceName' shall be assigned to. This must be either a 'Transaction', 'Branch' or 'Tag' via which the hash is visible to the caller.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="refObj"), @ExampleObject(ref="tagObj")})}) Reference var4) throws NessieNotFoundException, NessieConflictException;

    @Override
    @DELETE
    @Path(value="{referenceType}/{referenceName}")
    @Operation(summary="Delete a reference endpoint")
    @APIResponses(value={@APIResponse(responseCode="204", description="Deleted successfully."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view or delete reference"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    public void deleteReference(@Parameter(description="Reference type to delete", examples={@ExampleObject(ref="referenceType")}) @PathParam(value="referenceType") Reference.ReferenceType var1, @Parameter(description="Reference name to delete", examples={@ExampleObject(ref="ref")}) @PathParam(value="referenceName") String var2, @Parameter(description="Expected hash of tag", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") String var3) throws NessieConflictException, NessieNotFoundException;

    @Override
    @POST
    @Produces(value={"application/json"})
    @Path(value="branch/{branchName}/transplant")
    @Operation(summary="Transplant commits from 'transplant' onto 'branchName'", description="This is done as an atomic operation such that only the last of the sequence is ever visible to concurrent readers/writers. The sequence to transplant must be contiguous and in order.")
    @APIResponses(value={@APIResponse(responseCode="204", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="mergeResponseSuccess"), @ExampleObject(ref="mergeResponseFail")}, schema=@Schema(implementation=MergeResponse.class))}, description="Transplant operation completed. The actual transplant might have failed and reported as successful=false, if the client asked to return a conflict as a result instead of returning an error. Note: the 'commonAncestor' field in a response will always be null for a transplant."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or transplant commits"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    public MergeResponse transplantCommitsIntoBranch(@Parameter(description="Branch to transplant into", examples={@ExampleObject(ref="ref")}) @PathParam(value="branchName") String var1, @Parameter(description="Expected hash of tag.", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") String var2, @Parameter(description="commit message", examples={@ExampleObject(ref="commitMessage")}) @QueryParam(value="message") String var3, @RequestBody(description="Hashes to transplant", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="transplant")})}) Transplant var4) throws NessieNotFoundException, NessieConflictException;

    @Override
    @POST
    @Produces(value={"application/json"})
    @Path(value="branch/{branchName}/merge")
    @Operation(summary="Merge commits from 'mergeRef' onto 'branchName'.", description="Merge items from an existing hash in 'mergeRef' into the requested branch. The merge is always a rebase + fast-forward merge and is only completed if the rebase is conflict free. The set of commits added to the branch will be all of those until we arrive at a common ancestor. Depending on the underlying implementation, the number of commits allowed as part of this operation may be limited.")
    @APIResponses(value={@APIResponse(responseCode="204", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="mergeResponseSuccess"), @ExampleObject(ref="mergeResponseFail")}, schema=@Schema(implementation=MergeResponse.class))}, description="Merge operation completed. The actual merge might have failed and reported as successful=false, if the client asked to return a conflict as a result instead of returning an error."), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or merge commits"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="409", description="update conflict")})
    public MergeResponse mergeRefIntoBranch(@Parameter(description="Branch to merge into", examples={@ExampleObject(ref="ref")}) @PathParam(value="branchName") String var1, @Parameter(description="Expected current HEAD of 'branchName'", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") String var2, @RequestBody(description="Merge operation that defines the source reference name and an optional hash. If 'fromHash' is not present, the current 'sourceRef's HEAD will be used.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="merge")})}) Merge var3) throws NessieNotFoundException, NessieConflictException;

    @Override
    @POST
    @Path(value="branch/{branchName}/commit")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Operation(summary="Commit multiple operations against the given branch expecting that branch to have the given hash as its latest commit. The hash in the successful response contains the hash of the commit that contains the operations of the invocation.")
    @APIResponses(value={@APIResponse(responseCode="200", description="Updated successfully.", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="refObj")}, schema=@Schema(implementation=Branch.class))}), @APIResponse(responseCode="400", description="Invalid input, ref/hash name not valid"), @APIResponse(responseCode="401", description="Invalid credentials provided"), @APIResponse(responseCode="403", description="Not allowed to view the given reference or perform commits"), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="409", description="Update conflict")})
    public Branch commitMultipleOperations(@Parameter(description="Branch to change, defaults to default branch.", examples={@ExampleObject(ref="ref")}) @PathParam(value="branchName") String var1, @Parameter(description="Expected hash of branch.", examples={@ExampleObject(ref="hash")}) @QueryParam(value="expectedHash") String var2, @RequestBody(description="Operations", content={@Content(mediaType="application/json", examples={@ExampleObject(ref="operations")})}) Operations var3) throws NessieNotFoundException, NessieConflictException;
}

