/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v1api;

import java.util.stream.Stream;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.api.params.EntriesParamsBuilder;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.http.NessieApiClient;
import org.projectnessie.client.http.v1api.BaseHttpOnReferenceRequest;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.EntriesResponse;

final class HttpGetEntries
extends BaseHttpOnReferenceRequest<GetEntriesBuilder>
implements GetEntriesBuilder {
    private final EntriesParamsBuilder params = EntriesParams.builder();

    HttpGetEntries(NessieApiClient client) {
        super(client);
    }

    @Override
    public GetEntriesBuilder maxRecords(int maxRecords) {
        this.params.maxRecords(maxRecords);
        return this;
    }

    @Override
    public GetEntriesBuilder pageToken(String pageToken) {
        this.params.pageToken(pageToken);
        return this;
    }

    @Override
    public GetEntriesBuilder filter(String filter) {
        this.params.filter(filter);
        return this;
    }

    @Override
    public GetEntriesBuilder namespaceDepth(Integer namespaceDepth) {
        this.params.namespaceDepth(namespaceDepth);
        return this;
    }

    private EntriesParams params() {
        this.params.hashOnRef(this.hashOnRef);
        return this.params.build();
    }

    @Override
    public EntriesResponse get() throws NessieNotFoundException {
        return this.get(this.params());
    }

    private EntriesResponse get(EntriesParams p) throws NessieNotFoundException {
        return this.client.getTreeApi().getEntries(this.refName, p);
    }

    @Override
    public Stream<EntriesResponse.Entry> stream() throws NessieNotFoundException {
        EntriesParams p = this.params();
        return StreamingUtil.generateStream(EntriesResponse::getEntries, pageToken -> this.get(p.forNextPage(pageToken)));
    }
}

