/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.immutables.value.Value;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableMergeKeyBehavior;

public interface BaseMergeTransplant {
    @NotBlank
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    public @NotBlank @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String getFromRefName();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean keepIndividualCommits();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<MergeKeyBehavior> getKeyMergeModes();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MergeBehavior getDefaultKeyMergeMode();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean isDryRun();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean isFetchAdditionalInfo();

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean isReturnConflictAsResult();

    public static enum MergeBehavior {
        NORMAL,
        FORCE,
        DROP;

    }

    @JsonSerialize(as=ImmutableMergeKeyBehavior.class)
    @JsonDeserialize(as=ImmutableMergeKeyBehavior.class)
    @Value.Immutable
    public static interface MergeKeyBehavior {
        public ContentKey getKey();

        public MergeBehavior getMergeBehavior();

        public static ImmutableMergeKeyBehavior.Builder builder() {
            return ImmutableMergeKeyBehavior.builder();
        }

        public static MergeKeyBehavior of(ContentKey key, MergeBehavior mergeBehavior) {
            return MergeKeyBehavior.builder().key(key).mergeBehavior(mergeBehavior).build();
        }
    }
}

