/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.params.AbstractParams;
import org.projectnessie.api.params.EntriesParamsBuilder;

public class EntriesParams
extends AbstractParams {
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="hashOnRef")
    private @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String hashOnRef;
    @Nullable
    @Parameter(description="If set > 0 will filter the results to only return namespaces/tables to the depth of namespaceDepth. If not set or <=0 has no effect\nSetting this parameter > 0 will turn off paging.")
    @QueryParam(value="namespaceDepth")
    private Integer namespaceDepth;
    @Nullable
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are 'entry.namespace' (string) & 'entry.contentType' (string)", examples={@ExampleObject(ref="expr_by_namespace"), @ExampleObject(ref="expr_by_contentType"), @ExampleObject(ref="expr_by_namespace_and_contentType")})
    @QueryParam(value="filter")
    private String filter;

    public EntriesParams() {
    }

    @Builder.Constructor
    EntriesParams(@Nullable String hashOnRef, @Nullable Integer maxRecords, @Nullable String pageToken, @Nullable Integer namespaceDepth, @Nullable String filter) {
        super(maxRecords, pageToken);
        this.hashOnRef = hashOnRef;
        this.namespaceDepth = namespaceDepth;
        this.filter = filter;
    }

    public static EntriesParamsBuilder builder() {
        return new EntriesParamsBuilder();
    }

    public static EntriesParams empty() {
        return EntriesParams.builder().build();
    }

    @Nullable
    public String hashOnRef() {
        return this.hashOnRef;
    }

    @Nullable
    public String filter() {
        return this.filter;
    }

    @Nullable
    public Integer namespaceDepth() {
        return this.namespaceDepth;
    }

    public String toString() {
        return new StringJoiner(", ", EntriesParams.class.getSimpleName() + "[", "]").add("hashOnRef='" + this.hashOnRef + "'").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").add("filter='" + this.filter + "'").add("namespaceDepth='" + this.namespaceDepth + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntriesParams)) {
            return false;
        }
        EntriesParams that = (EntriesParams)o;
        return Objects.equals(this.hashOnRef, that.hashOnRef) && Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken()) && Objects.equals(this.namespaceDepth, that.namespaceDepth) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.hashOnRef, this.maxRecords(), this.pageToken(), this.namespaceDepth, this.filter);
    }
}

