/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.gc.actions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.gc.actions.GcActionsConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GcActionsConfig", generator="Immutables")
@Immutable
public final class ImmutableGcActionsConfig
implements GcActionsConfig {
    private final String dynamoRegion;
    @Nullable
    private final String dynamoEndpoint;
    private final GcActionsConfig.StoreType storeType;

    private ImmutableGcActionsConfig(String dynamoRegion, @Nullable String dynamoEndpoint, GcActionsConfig.StoreType storeType) {
        this.dynamoRegion = dynamoRegion;
        this.dynamoEndpoint = dynamoEndpoint;
        this.storeType = storeType;
    }

    @Override
    public String getDynamoRegion() {
        return this.dynamoRegion;
    }

    @Override
    @Nullable
    public String getDynamoEndpoint() {
        return this.dynamoEndpoint;
    }

    @Override
    public GcActionsConfig.StoreType getStoreType() {
        return this.storeType;
    }

    public final ImmutableGcActionsConfig withDynamoRegion(String value) {
        String newValue = Objects.requireNonNull(value, "dynamoRegion");
        if (this.dynamoRegion.equals(newValue)) {
            return this;
        }
        return new ImmutableGcActionsConfig(newValue, this.dynamoEndpoint, this.storeType);
    }

    public final ImmutableGcActionsConfig withDynamoEndpoint(@Nullable String value) {
        if (Objects.equals(this.dynamoEndpoint, value)) {
            return this;
        }
        return new ImmutableGcActionsConfig(this.dynamoRegion, value, this.storeType);
    }

    public final ImmutableGcActionsConfig withStoreType(GcActionsConfig.StoreType value) {
        if (this.storeType == value) {
            return this;
        }
        GcActionsConfig.StoreType newValue = Objects.requireNonNull(value, "storeType");
        if (this.storeType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableGcActionsConfig(this.dynamoRegion, this.dynamoEndpoint, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGcActionsConfig && this.equalTo((ImmutableGcActionsConfig)another);
    }

    private boolean equalTo(ImmutableGcActionsConfig another) {
        return this.dynamoRegion.equals(another.dynamoRegion) && Objects.equals(this.dynamoEndpoint, another.dynamoEndpoint) && this.storeType.equals((Object)another.storeType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.dynamoRegion.hashCode();
        h += (h << 5) + Objects.hashCode(this.dynamoEndpoint);
        h += (h << 5) + this.storeType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GcActionsConfig").omitNullValues().add("dynamoRegion", (Object)this.dynamoRegion).add("dynamoEndpoint", (Object)this.dynamoEndpoint).add("storeType", (Object)this.storeType).toString();
    }

    public static ImmutableGcActionsConfig copyOf(GcActionsConfig instance) {
        if (instance instanceof ImmutableGcActionsConfig) {
            return (ImmutableGcActionsConfig)instance;
        }
        return ImmutableGcActionsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GcActionsConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DYNAMO_REGION = 1L;
        private static final long INIT_BIT_STORE_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String dynamoRegion;
        @Nullable
        private String dynamoEndpoint;
        @Nullable
        private GcActionsConfig.StoreType storeType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GcActionsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.dynamoRegion(instance.getDynamoRegion());
            String dynamoEndpointValue = instance.getDynamoEndpoint();
            if (dynamoEndpointValue != null) {
                this.dynamoEndpoint(dynamoEndpointValue);
            }
            this.storeType(instance.getStoreType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dynamoRegion(String dynamoRegion) {
            this.dynamoRegion = Objects.requireNonNull(dynamoRegion, "dynamoRegion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dynamoEndpoint(@Nullable String dynamoEndpoint) {
            this.dynamoEndpoint = dynamoEndpoint;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder storeType(GcActionsConfig.StoreType storeType) {
            this.storeType = Objects.requireNonNull(storeType, "storeType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGcActionsConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGcActionsConfig(this.dynamoRegion, this.dynamoEndpoint, this.storeType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dynamoRegion");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("storeType");
            }
            return "Cannot build GcActionsConfig, some of required attributes are not set " + attributes;
        }
    }
}

