/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.actions.BaseSparkAction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.SerializableConfiguration;
import org.projectnessie.versioned.gc.AssetKey;
import org.projectnessie.versioned.gc.AssetKeySerializer;
import org.projectnessie.versioned.gc.actions.GcActionUtils;
import scala.Tuple2;

public class GcTableCleanAction
extends BaseSparkAction<GcTableCleanAction, GcTableCleanResult> {
    private final Table table;
    private final AssetKeySerializer assetKeySerializer;
    private long seenCount = 10L;
    private boolean deleteOnPurge = true;
    private boolean dropGcTable = true;

    public GcTableCleanAction(Table table, SparkSession spark) {
        super(spark);
        this.table = table;
        Configuration hadoopConfig = spark.sessionState().newHadoopConf();
        SerializableConfiguration configuration = new SerializableConfiguration(hadoopConfig);
        this.assetKeySerializer = new AssetKeySerializer(configuration);
    }

    public GcTableCleanAction deleteOnPurge(boolean deleteOnPurge) {
        this.deleteOnPurge = deleteOnPurge;
        return this;
    }

    public GcTableCleanAction dropGcTable(boolean dropGcTable) {
        this.dropGcTable = dropGcTable;
        return this;
    }

    public GcTableCleanAction deleteCountThreshold(long seenCount) {
        this.seenCount = seenCount;
        return this;
    }

    public GcTableCleanResult execute() {
        Dataset<Row> purgeResult = this.purgeUnreferencedAssetTable();
        if (this.deleteOnPurge) {
            this.cleanUnreferencedAssetTable(purgeResult, this.dropGcTable);
        }
        Row count = (Row)purgeResult.withColumn("deleted", purgeResult.col("_2").cast("int")).agg((Map)ImmutableMap.of((Object)"deleted", (Object)"sum", (Object)"_2", (Object)"count")).first();
        return new GcTableCleanResult(count.getLong(1), count.getLong(1) - count.getLong(0));
    }

    private String tableName() {
        return String.format("%s", this.table.name());
    }

    private Dataset<Row> purgeUnreferencedAssetTable() {
        long currentRunId = GcActionUtils.getMaxRunId(this.spark(), this.table.name());
        Dataset deletable = this.spark().sql(String.format("SELECT count(*) as counted, name, last(timestamp) as timestamp, last(asset) as asset, max(runid) as runid FROM %s GROUP BY name HAVING counted >= %d AND runid = %d", this.tableName(), this.seenCount, currentRunId));
        Dataset deletes = deletable.map((MapFunction)new DeleteFunction(this.assetKeySerializer), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.BOOLEAN()));
        return deletable.joinWith(deletes, deletable.col("name").equalTo((Object)deletes.col(deletes.columns()[0]))).select("_1.counted", new String[]{"_1.name", "_1.timestamp", "_1.asset", "_1.runid", "_2._2"});
    }

    private void cleanUnreferencedAssetTable(Dataset<Row> deleted, boolean purge) {
        if (!purge) {
            throw new UnsupportedOperationException("Not Yet Implemented");
        }
        this.spark().sql(String.format("DROP TABLE %s", this.tableName()));
    }

    protected GcTableCleanAction self() {
        return this;
    }

    private static class DeleteFunction
    implements MapFunction<Row, Tuple2<String, Boolean>> {
        private final AssetKeySerializer assetKeySerializer;

        private DeleteFunction(AssetKeySerializer assetKeySerializer) {
            this.assetKeySerializer = assetKeySerializer;
        }

        public Tuple2<String, Boolean> call(Row value) throws Exception {
            AssetKey assetKey = this.assetKeySerializer.fromBytes(ByteString.copyFrom((byte[])((byte[])value.get(3))));
            return Tuple2.apply((Object)value.getString(1), (Object)((Boolean)assetKey.delete().toCompletableFuture().get()));
        }
    }

    public static class GcTableCleanResult {
        private final long deletedAssetCount;
        private final long failedDeletes;

        public GcTableCleanResult(long deletedAssetCount, long failedDeletes) {
            this.deletedAssetCount = deletedAssetCount;
            this.failedDeletes = failedDeletes;
        }

        public long getDeletedAssetCount() {
            return this.deletedAssetCount;
        }

        public long getFailedDeletes() {
            return this.failedDeletes;
        }
    }
}

