/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.gc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.gc.AssetKey;

public final class GcTestUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private GcTestUtils() {
    }

    public static class DummyAsset
    extends AssetKey {
        private int id;

        @JsonCreator
        public DummyAsset(@JsonProperty(value="id") int id) {
            this.id = id;
        }

        public DummyAsset() {
        }

        public int getId() {
            return this.id;
        }

        public CompletableFuture<Boolean> delete() {
            return CompletableFuture.completedFuture(true);
        }

        public List<String> toReportableName() {
            return Arrays.asList(Integer.toString(this.id));
        }

        public ByteString toUniqueKey() {
            return ByteString.copyFromUtf8((String)Integer.toString(this.id));
        }

        public boolean equals(Object other) {
            return other != null && other instanceof DummyAsset && ((DummyAsset)((Object)other)).id == this.id;
        }

        public int hashCode() {
            return Integer.hashCode(this.id);
        }
    }

    public static class DummyAssetKeySerializer
    implements Serializer<AssetKey>,
    Serializable {
        private final Serializer<DummyAsset> delegate = new JsonSerializer<DummyAsset>(DummyAsset.class);

        public ByteString toBytes(AssetKey value) {
            return this.delegate.toBytes((Object)((DummyAsset)value));
        }

        public AssetKey fromBytes(ByteString bytes) {
            return (AssetKey)this.delegate.fromBytes(bytes);
        }
    }

    public static class JsonSerializer<T>
    implements Serializer<T>,
    Serializable {
        private static final long serialVersionUID = 4052464280276785753L;
        private final Class<T> clazz;

        public JsonSerializer(Class<T> clazz) {
            this.clazz = clazz;
        }

        public ByteString toBytes(T value) {
            try {
                return ByteString.copyFrom((byte[])MAPPER.writer().writeValueAsBytes(value));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public T fromBytes(ByteString bytes) {
            try {
                return (T)MAPPER.reader().readValue(bytes.toByteArray(), this.clazz);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

