/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.gc;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.gc.AssetKey;
import org.projectnessie.versioned.gc.AssetKeyConverter;
import org.projectnessie.versioned.gc.BinaryBloomFilter;
import org.projectnessie.versioned.gc.CategorizedValue;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

public class IdentifyUnreferencedAssets<T, R extends AssetKey> {
    protected final Serializer<T> valueSerializer;
    private final Serializer<AssetKey> assetKeySerializer;
    private final AssetKeyConverter<T, R> assetKeyConverter;
    private final FilterFunction<CategorizedValue> valueTypeFilter;
    private final SparkSession spark;

    public IdentifyUnreferencedAssets(Serializer<T> valueSerializer, Serializer<AssetKey> assetKeySerializer, AssetKeyConverter<T, R> assetKeyConverter, FilterFunction<CategorizedValue> valueTypeFilter, SparkSession spark) {
        this.valueSerializer = valueSerializer;
        this.assetKeySerializer = assetKeySerializer;
        this.assetKeyConverter = assetKeyConverter;
        this.valueTypeFilter = valueTypeFilter;
        this.spark = spark;
    }

    public Dataset<UnreferencedItem> identify(Dataset<CategorizedValue> categorizedValues) {
        return IdentifyUnreferencedAssets.go(this.valueSerializer, categorizedValues, this.assetKeySerializer, this.assetKeyConverter, this.valueTypeFilter, this.spark);
    }

    private static <T, R extends AssetKey> Dataset<UnreferencedItem> go(Serializer<T> valueSerializer, Dataset<CategorizedValue> categorizedValues, Serializer<AssetKey> assetKeySerializer, AssetKeyConverter<T, R> assetKeyConverter, FilterFunction<CategorizedValue> valueTypeFilter, SparkSession spark) {
        AssetFlatMapper<T, R> mapper = new AssetFlatMapper<T, R>(valueSerializer, assetKeySerializer, assetKeyConverter);
        Dataset assets = categorizedValues.filter(valueTypeFilter).flatMap(mapper, Encoders.bean(CategorizedAssetKey.class));
        BinaryBloomFilter referencedAssets = BinaryBloomFilter.aggregate((Dataset<Row>)assets.filter("referenced = true").select("uniqueKey", new String[0]), "uniqueKey");
        Dataset unreferencedAssets = assets.filter("referenced = false").select("data", new String[]{"timestamp", "uniqueKey", "key"}).filter((FilterFunction)new AssetFilter(referencedAssets)).dropDuplicates("uniqueKey", new String[0]);
        return unreferencedAssets.map((Function1)new UnreferencedItemConverter(assetKeySerializer), Encoders.bean(UnreferencedItem.class));
    }

    public static class AssetFlatMapper<T, R extends AssetKey>
    implements FlatMapFunction<CategorizedValue, CategorizedAssetKey> {
        private static final long serialVersionUID = -4605489080345105845L;
        private final Serializer<T> valueWorker;
        private final Serializer<AssetKey> assetKeySerializer;
        private final AssetKeyConverter<T, R> assetKeyConverter;

        public AssetFlatMapper(Serializer<T> valueWorker, Serializer<AssetKey> assetKeySerializer, AssetKeyConverter<T, R> assetKeyConverter) {
            this.valueWorker = valueWorker;
            this.assetKeySerializer = assetKeySerializer;
            this.assetKeyConverter = assetKeyConverter;
        }

        public Iterator<CategorizedAssetKey> call(CategorizedValue r) throws Exception {
            Object contents = this.valueWorker.fromBytes(ByteString.copyFrom((byte[])r.getData()));
            return ((Stream)this.assetKeyConverter.apply(contents)).map(ak -> new CategorizedAssetKey(r.isReferenced(), this.assetKeySerializer.toBytes(ak), ak.toUniqueKey(), r.getTimestamp(), r.getKey())).iterator();
        }
    }

    public static class UnreferencedItem
    implements Serializable {
        private static final long serialVersionUID = -5566256066143995534L;
        private String name;
        private byte[] asset;
        private long timestamp;
        private List<String> key;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public byte[] getAsset() {
            return this.asset;
        }

        public void setAsset(byte[] asset) {
            this.asset = asset;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public List<String> getKey() {
            return this.key;
        }

        public void setKey(List<String> key) {
            this.key = key;
        }
    }

    public static class UnreferencedItemConverter
    implements Function1<Row, UnreferencedItem>,
    Serializable {
        private static final long serialVersionUID = -5135625090051205329L;
        private final Serializer<AssetKey> serializer;

        public UnreferencedItemConverter(Serializer<AssetKey> serializer) {
            this.serializer = serializer;
        }

        public UnreferencedItem apply(Row r) {
            byte[] asset = (byte[])r.getAs("data");
            AssetKey key = (AssetKey)this.serializer.fromBytes(UnsafeByteOperations.unsafeWrap((byte[])asset));
            UnreferencedItem ui = new UnreferencedItem();
            ui.setName(key.toReportableName().stream().collect(Collectors.joining(".")));
            ui.setAsset(asset);
            ui.setTimestamp((Long)r.getAs("timestamp"));
            ui.setKey(Lists.newArrayList((java.lang.Iterable)JavaConverters.asJavaCollection((Iterable)((Iterable)r.getAs("key")))));
            return ui;
        }
    }

    public static final class CategorizedAssetKey
    implements Serializable {
        private static final long serialVersionUID = -1466847843373432962L;
        private boolean referenced;
        private byte[] data;
        private byte[] uniqueKey;
        private long timestamp;
        private List<String> key;

        public CategorizedAssetKey() {
        }

        public CategorizedAssetKey(boolean referenced, ByteString data, ByteString uniqueKey, long timestamp, List<String> key) {
            this.referenced = referenced;
            this.data = data.toByteArray();
            this.uniqueKey = uniqueKey.toByteArray();
            this.timestamp = timestamp;
            this.key = key;
        }

        public void setReferenced(boolean referenced) {
            this.referenced = referenced;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public boolean isReferenced() {
            return this.referenced;
        }

        public byte[] getData() {
            return this.data;
        }

        public byte[] getUniqueKey() {
            return this.uniqueKey;
        }

        public void setUniqueKey(byte[] uniqueKey) {
            this.uniqueKey = uniqueKey;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public List<String> getKey() {
            return this.key;
        }

        public void setKey(List<String> key) {
            this.key = key;
        }
    }

    public static class AssetFilter
    implements FilterFunction<Row> {
        private static final long serialVersionUID = 2411246084016802962L;
        private BinaryBloomFilter filter;

        public AssetFilter(BinaryBloomFilter filter) {
            this.filter = filter;
        }

        public boolean call(Row r) throws Exception {
            byte[] bytes = (byte[])r.getAs("uniqueKey");
            return !this.filter.mightContain(bytes);
        }
    }
}

