/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.gc;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.Aggregator;
import org.apache.spark.sql.functions;

public class BinaryBloomFilter
implements Externalizable {
    private static final Funnel<ByteBuffer> BYTE_FUNNEL = new BinaryFunnel();
    private static final int SIZE = 10000000;
    private static final Encoder<BinaryBloomFilter> ENCODER = Encoders.kryo(BinaryBloomFilter.class);
    private BloomFilter<ByteBuffer> filter = BloomFilter.create(BYTE_FUNNEL, (int)10000000);

    public boolean mightContain(byte[] bytes) {
        return this.filter.mightContain((Object)ByteBuffer.wrap(bytes));
    }

    public boolean mightContain(ByteString bytes) {
        return this.filter.mightContain((Object)bytes.asReadOnlyByteBuffer());
    }

    public boolean mightContain(ByteBuffer bytes) {
        return this.filter.mightContain((Object)bytes);
    }

    private static BinaryBloomFilter fromBinary(byte[] bytes) {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        BinaryBloomFilter filter = new BinaryBloomFilter();
        try {
            filter.filter = BloomFilter.readFrom((InputStream)input, BYTE_FUNNEL);
            return filter;
        }
        catch (IOException e) {
            throw new RuntimeException("Failure reading bloom filter.", e);
        }
    }

    public static BinaryBloomFilter aggregate(Dataset<Row> data, String column) {
        Row[] aggregated = (Row[])data.agg(functions.udaf((Aggregator)new BloomFilterAggregator(), (Encoder)Encoders.BINARY()).apply(new Column[]{data.col(column)}), new Column[0]).collect();
        byte[] bytes = (byte[])aggregated[0].getAs(0);
        return BinaryBloomFilter.fromBinary(bytes);
    }

    public Dataset<Row> filter(Dataset<Row> data, String column) {
        return data.filter(BinaryBloomFilter.filter(this, column));
    }

    private static FilterFunction<Row> filter(BinaryBloomFilter bloomFilter, String column) {
        return (FilterFunction & Serializable)f -> {
            byte[] bytes = (byte[])f.getAs(column);
            return bloomFilter.mightContain(bytes);
        };
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.filter.writeTo((OutputStream)baos);
        baos.flush();
        byte[] bytes = baos.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        this.filter = BloomFilter.readFrom((InputStream)new ByteArrayInputStream(bytes), BYTE_FUNNEL);
    }

    private static class BinaryFunnel
    implements Funnel<ByteBuffer> {
        private static final long serialVersionUID = 1308914370144641865L;

        private BinaryFunnel() {
        }

        public void funnel(ByteBuffer from, PrimitiveSink into) {
            into.putBytes(from);
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof BinaryFunnel;
        }
    }

    private static class BloomFilterAggregator
    extends Aggregator<byte[], BinaryBloomFilter, byte[]> {
        private static final long serialVersionUID = -537765519777214377L;

        private BloomFilterAggregator() {
        }

        public Encoder<BinaryBloomFilter> bufferEncoder() {
            return ENCODER;
        }

        public byte[] finish(BinaryBloomFilter reduction) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                reduction.filter.writeTo((OutputStream)baos);
                baos.flush();
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception while serializing to byte array.", e);
            }
        }

        public BinaryBloomFilter merge(BinaryBloomFilter b1, BinaryBloomFilter b2) {
            b1.filter.putAll(b2.filter);
            return b1;
        }

        public Encoder<byte[]> outputEncoder() {
            return Encoders.BINARY();
        }

        public BinaryBloomFilter reduce(BinaryBloomFilter b, byte[] a) {
            b.filter.put((Object)ByteBuffer.wrap(a));
            return b;
        }

        public BinaryBloomFilter zero() {
            return new BinaryBloomFilter();
        }
    }
}

