/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.gc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.gc.AssetKeyConverter;
import org.projectnessie.versioned.gc.CategorizedValue;
import org.projectnessie.versioned.gc.GcTestUtils;
import org.projectnessie.versioned.gc.IdentifyUnreferencedAssets;

class ITIdentifyUnreferencedAssets {
    private static final Multimap<String, GcTestUtils.DummyAsset> ASSETS = ImmutableMultimap.builder().put((Object)"a", (Object)ITIdentifyUnreferencedAssets.get(1)).put((Object)"a", (Object)ITIdentifyUnreferencedAssets.get(2)).put((Object)"b", (Object)ITIdentifyUnreferencedAssets.get(1)).put((Object)"c", (Object)ITIdentifyUnreferencedAssets.get(1)).put((Object)"c", (Object)ITIdentifyUnreferencedAssets.get(3)).build();

    ITIdentifyUnreferencedAssets() {
    }

    private static GcTestUtils.DummyAsset get(int i) {
        return new GcTestUtils.DummyAsset(i);
    }

    @Test
    void test() {
        SparkSession spark = SparkSession.builder().appName("test-nessie-gc-collection").master("local[2]").getOrCreate();
        IdentifyUnreferencedAssets ident = new IdentifyUnreferencedAssets((Serializer)new DummyValueSerializer(), (Serializer)new GcTestUtils.DummyAssetKeySerializer(), (AssetKeyConverter)new DummyAssetConverter(), (FilterFunction & Serializable)v -> true, spark);
        Dataset items = ident.identify(this.generate(spark));
        Set unreferencedItems = items.collectAsList().stream().map(IdentifyUnreferencedAssets.UnreferencedItem::getName).collect(Collectors.toSet());
        Assertions.assertThat(unreferencedItems).containsExactlyInAnyOrder((Object[])new String[]{"2"});
    }

    private Dataset<CategorizedValue> generate(SparkSession spark) {
        ArrayList<String[]> stringAsList = new ArrayList<String[]>();
        stringAsList.add(new String[]{"a", "false"});
        stringAsList.add(new String[]{"b", "true"});
        stringAsList.add(new String[]{"c", "true"});
        JavaSparkContext sparkContext = new JavaSparkContext(spark.sparkContext());
        JavaRDD rowRDD = sparkContext.parallelize(stringAsList).map(RowFactory::create);
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.StringType, (boolean)false), DataTypes.createStructField((String)"referenced", (DataType)DataTypes.StringType, (boolean)false)});
        DummyValueSerializer ser = new DummyValueSerializer();
        return spark.sqlContext().createDataFrame(rowRDD, schema).map((MapFunction & Serializable)x -> {
            boolean referenced = Boolean.parseBoolean(x.getString(1));
            DummyValue value = new DummyValue(x.getString(0));
            ByteString data = ser.toBytes(value);
            return new CategorizedValue(referenced, data, 0L, Collections.singletonList("na"));
        }, Encoders.bean(CategorizedValue.class));
    }

    private static class DummyValue {
        private final String id;

        @JsonCreator
        public DummyValue(@JsonProperty(value="id") String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class DummyAssetConverter
    implements AssetKeyConverter<DummyValue, GcTestUtils.DummyAsset>,
    Serializable {
        private DummyAssetConverter() {
        }

        public Stream<GcTestUtils.DummyAsset> apply(DummyValue value) {
            return ASSETS.get((Object)value.getId()).stream();
        }
    }

    private static class DummyValueSerializer
    extends GcTestUtils.JsonSerializer<DummyValue>
    implements Serializable {
        public DummyValueSerializer() {
            super(DummyValue.class);
        }
    }
}

