/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.benchmarks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceRetryFailureException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.StringStoreWorker;
import org.projectnessie.versioned.persist.adapter.AdjustableDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterFactory;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionConfig;
import org.projectnessie.versioned.persist.store.PersistVersionStore;
import org.projectnessie.versioned.persist.tests.SystemPropertiesConfigurer;
import org.projectnessie.versioned.persist.tests.extension.TestConnectionProviderSource;

@Warmup(iterations=2, time=2000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=3, time=5000, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=1)
@Threads(value=4)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
public class CommitBench {
    @Benchmark
    public void singleBranchSharedKeys(BenchmarkParam bp) throws Exception {
        this.doCommit(bp, bp.branch, bp.keys, bp.contentIds);
    }

    @Benchmark
    public void branchPerThreadSharedKeys(BenchmarkParam bp, ThreadParam tp) throws Exception {
        this.doCommit(bp, tp.branch, bp.keys, bp.contentIds);
    }

    @Benchmark
    public void singleBranchUnsharedKeys(BenchmarkParam bp, ThreadParam tp) throws Exception {
        this.doCommit(bp, bp.branch, tp.keys, tp.contentIds);
    }

    @Benchmark
    public void branchPerThreadUnsharedKeys(BenchmarkParam bp, ThreadParam tp) throws Exception {
        this.doCommit(bp, tp.branch, tp.keys, tp.contentIds);
    }

    private void doCommit(BenchmarkParam bp, BranchName branch, List<Key> keys, Map<Key, String> contentIds) throws Exception {
        Map contentByKey = bp.versionStore.getValues((Ref)branch, keys);
        try {
            ArrayList<Put> operations = new ArrayList<Put>(bp.tablesPerCommit);
            for (int i = 0; i < bp.tablesPerCommit; ++i) {
                Key key = keys.get(i);
                String value = (String)contentByKey.get(key);
                if (value == null) {
                    throw new RuntimeException("no value for key " + key + " in " + branch);
                }
                String currentState = value.split("\\|")[0];
                String newGlobalState = Integer.toString(Integer.parseInt(currentState) + 1);
                String contentId = contentIds.get(key);
                operations.add(Put.of((Key)key, (Object)StringStoreWorker.withStateAndId((String)newGlobalState, (String)("commit value " + ThreadLocalRandom.current().nextLong()), (String)contentId), (Object)StringStoreWorker.withStateAndId((String)currentState, (String)"foo", (String)contentId)));
            }
            bp.versionStore.commit(branch, Optional.empty(), (Object)"commit meta data", operations);
            bp.success.incrementAndGet();
        }
        catch (ReferenceRetryFailureException e) {
            bp.retryFailures.incrementAndGet();
        }
        catch (ReferenceConflictException e) {
            bp.conflictsFailures.incrementAndGet();
        }
    }

    static List<Operation<String>> initialOperations(BenchmarkParam bp, List<Key> keys, Map<Key, String> contentIds) {
        ArrayList<Operation<String>> operations = new ArrayList<Operation<String>>(bp.tablesPerCommit);
        for (Key key : keys) {
            String contentId = contentIds.get(key);
            operations.add((Operation<String>)Put.of((Key)key, (Object)StringStoreWorker.withStateAndId((String)"0", (String)"initial commit content", (String)contentId)));
        }
        return operations;
    }

    @State(value=Scope.Thread)
    public static class ThreadParam {
        BranchName branch;
        List<Key> keys;
        Map<Key, String> contentIds;

        @Setup
        public void createBranch(BenchmarkParam bp) throws Exception {
            this.branch = BranchName.of((String)("thread-" + Thread.currentThread().getId()));
            this.keys = new ArrayList<Key>(bp.tablesPerCommit);
            for (int i = 0; i < bp.tablesPerCommit; ++i) {
                Key key = Key.of((String[])new String[]{"per-thread", Long.toString(Thread.currentThread().getId()), "num" + i});
                this.keys.add(key);
            }
            this.contentIds = new HashMap<Key, String>(bp.contentIds);
            this.keys.forEach(k -> this.contentIds.put((Key)k, UUID.randomUUID().toString()));
            bp.versionStore.commit(bp.branch, Optional.empty(), (Object)("initial commit meta " + Thread.currentThread().getId()), CommitBench.initialOperations(bp, this.keys, this.contentIds));
            Hash hash = bp.versionStore.hashOnReference((NamedRef)bp.branch, Optional.empty());
            bp.versionStore.create((NamedRef)this.branch, Optional.of(hash));
        }
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkParam {
        @Param(value={"1", "3", "5"})
        public int tablesPerCommit;
        @Param(value={"H2:h2", "In-Memory", "RocksDB"})
        public String adapter;
        final AtomicInteger retryFailures = new AtomicInteger();
        final AtomicInteger conflictsFailures = new AtomicInteger();
        final AtomicInteger success = new AtomicInteger();
        TestConnectionProviderSource<DatabaseConnectionConfig> providerSource;
        DatabaseAdapter databaseAdapter;
        PersistVersionStore<String, String, StringStoreWorker.TestEnum> versionStore;
        List<Key> keys;
        Map<Key, String> contentIds;
        BranchName branch = BranchName.of((String)"main");

        @Setup
        public void init() throws Exception {
            this.databaseAdapter = this.adapterByName();
            this.databaseAdapter.eraseRepo();
            this.databaseAdapter.initializeRepo(this.branch.getName());
            this.versionStore = new PersistVersionStore(this.databaseAdapter, (StoreWorker)StringStoreWorker.INSTANCE);
            this.keys = new ArrayList<Key>(this.tablesPerCommit);
            for (int i = 0; i < this.tablesPerCommit; ++i) {
                Key key = Key.of((String[])new String[]{"my", "table", "num" + i});
                this.keys.add(key);
            }
            this.contentIds = this.keys.stream().collect(Collectors.toMap(k -> k, k -> UUID.randomUUID().toString()));
            this.versionStore.commit(this.branch, Optional.empty(), (Object)"initial commit meta", CommitBench.initialOperations(this, this.keys, this.contentIds));
        }

        private DatabaseAdapter adapterByName() {
            String adapterName = this.adapter.indexOf(58) <= 0 ? this.adapter : this.adapter.substring(0, this.adapter.indexOf(58));
            DatabaseAdapterFactory factory = DatabaseAdapterFactory.loadFactory(f -> f.getName().equalsIgnoreCase(adapterName));
            DatabaseAdapterFactory.Builder builder = factory.newBuilder().configure(x$0 -> SystemPropertiesConfigurer.configureAdapterFromSystemProperties((AdjustableDatabaseAdapterConfig)((AdjustableDatabaseAdapterConfig)x$0)));
            String providerSpec = this.adapter.indexOf(58) == -1 ? null : this.adapter.substring(this.adapter.indexOf(58) + 1).toLowerCase(Locale.ROOT);
            this.providerSource = TestConnectionProviderSource.findCompatibleProviderSource((DatabaseAdapterConfig)((DatabaseAdapterConfig)builder.getConfig()), (DatabaseAdapterFactory)factory, providerSpec);
            this.providerSource.configureConnectionProviderConfigFromDefaults(SystemPropertiesConfigurer::configureConnectionFromSystemProperties);
            try {
                this.providerSource.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return builder.withConnector((Object)this.providerSource.getConnectionProvider()).build();
        }

        @TearDown
        public void close() throws Exception {
            int retries = this.retryFailures.get();
            int conflicts = this.conflictsFailures.get();
            int successes = this.success.get();
            int total = retries + conflicts + successes;
            double retryRate = retries;
            retryRate /= (double)total;
            double conflictRate = conflicts;
            conflictRate /= (double)total;
            double successRate = successes;
            successRate /= (double)total;
            System.out.printf("(%.02f%% retries (%d), %.02f%% conflicts (%d), %.02f%% success (%d)) ", retryRate *= 100.0, retries, conflictRate *= 100.0, conflicts, successRate *= 100.0, successes);
            this.providerSource.stop();
        }
    }
}

