/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.store;

import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.WithType;
import org.projectnessie.versioned.persist.adapter.CommitAttempt;
import org.projectnessie.versioned.persist.adapter.ContentsAndState;
import org.projectnessie.versioned.persist.adapter.ContentsId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitAttempt;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

public class PersistVersionStore<CONTENTS, METADATA, CONTENTS_TYPE extends Enum<CONTENTS_TYPE>>
implements VersionStore<CONTENTS, METADATA, CONTENTS_TYPE> {
    private final DatabaseAdapter databaseAdapter;
    protected final StoreWorker<CONTENTS, METADATA, CONTENTS_TYPE> storeWorker;

    public PersistVersionStore(DatabaseAdapter databaseAdapter, StoreWorker<CONTENTS, METADATA, CONTENTS_TYPE> storeWorker) {
        this.databaseAdapter = databaseAdapter;
        this.storeWorker = storeWorker;
    }

    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.databaseAdapter.hashOnReference(namedReference, hashOnReference);
    }

    @Nonnull
    public Hash noAncestorHash() {
        return this.databaseAdapter.noAncestorHash();
    }

    @Nonnull
    public Hash toHash(@Nonnull NamedRef ref) throws ReferenceNotFoundException {
        return this.databaseAdapter.toHash(ref);
    }

    public WithHash<Ref> toRef(@Nonnull String refOfUnknownType) throws ReferenceNotFoundException {
        try {
            BranchName t = BranchName.of((String)refOfUnknownType);
            Hash h = this.toHash((NamedRef)t);
            return WithHash.of((Hash)h, (Object)t);
        }
        catch (ReferenceNotFoundException e) {
            TagName t = TagName.of((String)refOfUnknownType);
            Hash h = this.toHash((NamedRef)t);
            return WithHash.of((Hash)h, (Object)t);
        }
    }

    public Hash commit(@Nonnull BranchName branch, @Nonnull Optional<Hash> expectedHead, @Nonnull METADATA metadata, @Nonnull List<Operation<CONTENTS>> operations) throws ReferenceNotFoundException, ReferenceConflictException {
        ImmutableCommitAttempt.Builder commitAttempt = ImmutableCommitAttempt.builder().commitToBranch(branch).expectedHead(expectedHead);
        for (Operation<CONTENTS> operation : operations) {
            if (operation instanceof Put) {
                Put op = (Put)operation;
                ContentsId contentsId = ContentsId.of((String)this.storeWorker.getId(op.getValue()));
                commitAttempt.addPuts(KeyWithBytes.of((Key)op.getKey(), (ContentsId)contentsId, (byte)this.storeWorker.getPayload(op.getValue()), (ByteString)this.storeWorker.toStoreOnReferenceState(op.getValue())));
                if (this.storeWorker.requiresGlobalState(op.getValue())) {
                    Optional<Object> expectedValue;
                    ByteString newState = this.storeWorker.toStoreGlobalState(op.getValue());
                    if (op.getExpectedValue() != null) {
                        if (this.storeWorker.getType(op.getValue()) != this.storeWorker.getType(op.getExpectedValue())) {
                            throw new IllegalArgumentException(String.format("Contents-type for conditional put-operation for key '%s' for 'value' and 'expectedValue' must be the same, but are '%s' and '%s'.", op.getKey(), this.storeWorker.getType(op.getValue()), this.storeWorker.getType(op.getExpectedValue())));
                        }
                        if (!contentsId.equals((Object)ContentsId.of((String)this.storeWorker.getId(op.getExpectedValue())))) {
                            throw new IllegalArgumentException(String.format("Conditional put-operation key '%s' has different contents-ids.", op.getKey()));
                        }
                        expectedValue = Optional.of(this.storeWorker.toStoreGlobalState(op.getExpectedValue()));
                    } else {
                        expectedValue = Optional.empty();
                    }
                    commitAttempt.putExpectedStates(contentsId, expectedValue);
                    commitAttempt.putGlobal(contentsId, newState);
                    continue;
                }
                if (op.getExpectedValue() == null) continue;
                throw new IllegalArgumentException(String.format("Contents-type '%s' for put-operation for key '%s' does not support global state, expected-value not supported for this contents-type.", this.storeWorker.getType(op.getValue()), op.getKey()));
            }
            if (operation instanceof Delete) {
                commitAttempt.addDeletes(operation.getKey());
                continue;
            }
            if (operation instanceof Unchanged) {
                commitAttempt.addUnchanged(operation.getKey());
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown operation type '%s'", operation));
        }
        commitAttempt.commitMetaSerialized(this.storeWorker.getMetadataSerializer().toBytes(metadata));
        return this.databaseAdapter.commit((CommitAttempt)commitAttempt.build());
    }

    public void transplant(BranchName targetBranch, Optional<Hash> referenceHash, List<Hash> sequenceToTransplant) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.transplant(targetBranch, referenceHash, sequenceToTransplant);
    }

    public void merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.merge(fromHash, toBranch, expectedHash);
    }

    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.assign(ref, expectedHash, targetHash);
    }

    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.databaseAdapter.create(ref, targetHash.orElseGet(() -> ((DatabaseAdapter)this.databaseAdapter).noAncestorHash()));
    }

    public void delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.delete(ref, hash);
    }

    public Stream<WithHash<NamedRef>> getNamedRefs() {
        return this.databaseAdapter.namedRefs();
    }

    public Stream<WithHash<METADATA>> getCommits(Ref ref) throws ReferenceNotFoundException {
        Hash hash = ref instanceof NamedRef ? this.toHash((NamedRef)ref) : (Hash)ref;
        Stream stream = this.databaseAdapter.commitLog(hash);
        return stream.map(e -> WithHash.of((Hash)e.getHash(), (Object)this.storeWorker.getMetadataSerializer().fromBytes(e.getMetadata())));
    }

    public Stream<WithType<Key, CONTENTS_TYPE>> getKeys(Ref ref) throws ReferenceNotFoundException {
        Hash hash = ref instanceof NamedRef ? this.toHash((NamedRef)ref) : (Hash)ref;
        return this.databaseAdapter.keys(hash, KeyFilterPredicate.ALLOW_ALL).map(kt -> WithType.of((Enum)this.storeWorker.getType(Byte.valueOf(kt.getType())), (Object)kt.getKey()));
    }

    public CONTENTS getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        return this.getValues(ref, Collections.singletonList(key)).get(0).orElse(null);
    }

    public List<Optional<CONTENTS>> getValues(Ref ref, List<Key> keys) throws ReferenceNotFoundException {
        Hash hash = ref instanceof NamedRef ? this.toHash((NamedRef)ref) : (Hash)ref;
        try (Stream<Optional> values = this.databaseAdapter.values(hash, keys, KeyFilterPredicate.ALLOW_ALL).map(contentsAndStateOptional -> contentsAndStateOptional.map(this.mapContentsAndState()));){
            List<Optional<CONTENTS>> list = values.collect(Collectors.toList());
            return list;
        }
    }

    private Function<ContentsAndState<ByteString>, CONTENTS> mapContentsAndState() {
        return cs -> this.storeWorker.valueFromStore((ByteString)cs.getRefState(), Optional.ofNullable((ByteString)cs.getGlobalState()));
    }

    public Stream<Diff<CONTENTS>> getDiffs(Ref from, Ref to) throws ReferenceNotFoundException {
        Hash fromHash = from instanceof NamedRef ? this.toHash((NamedRef)from) : (Hash)from;
        Hash toHash = to instanceof NamedRef ? this.toHash((NamedRef)to) : (Hash)to;
        return this.databaseAdapter.diff(fromHash, toHash, KeyFilterPredicate.ALLOW_ALL).map(d -> Diff.of((Key)d.getKey(), d.getFromValue().map(v -> this.storeWorker.valueFromStore(v, d.getGlobal())), d.getToValue().map(v -> this.storeWorker.valueFromStore(v, d.getGlobal()))));
    }
}

