/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.store;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableCommit;
import org.projectnessie.versioned.ImmutableRefLogDetails;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.RefLogDetails;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithType;
import org.projectnessie.versioned.persist.adapter.CommitAttempt;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitAttempt;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

public class PersistVersionStore<CONTENT, METADATA, CONTENT_TYPE extends Enum<CONTENT_TYPE>>
implements VersionStore<CONTENT, METADATA, CONTENT_TYPE> {
    private final DatabaseAdapter databaseAdapter;
    protected final StoreWorker<CONTENT, METADATA, CONTENT_TYPE> storeWorker;

    public PersistVersionStore(DatabaseAdapter databaseAdapter, StoreWorker<CONTENT, METADATA, CONTENT_TYPE> storeWorker) {
        this.databaseAdapter = databaseAdapter;
        this.storeWorker = storeWorker;
    }

    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.databaseAdapter.hashOnReference(namedReference, hashOnReference);
    }

    @Nonnull
    public Hash noAncestorHash() {
        return this.databaseAdapter.noAncestorHash();
    }

    public Hash commit(@Nonnull BranchName branch, @Nonnull Optional<Hash> expectedHead, @Nonnull METADATA metadata, @Nonnull List<Operation<CONTENT>> operations, @Nonnull Callable<Void> validator) throws ReferenceNotFoundException, ReferenceConflictException {
        ImmutableCommitAttempt.Builder commitAttempt = ImmutableCommitAttempt.builder().commitToBranch(branch).expectedHead(expectedHead).commitMetaSerialized(this.serializeMetadata(metadata)).validator(validator);
        for (Operation<CONTENT> operation : operations) {
            if (operation instanceof Put) {
                Put op = (Put)operation;
                ContentId contentId = ContentId.of((String)this.storeWorker.getId(op.getValue()));
                commitAttempt.addPuts(KeyWithBytes.of((Key)op.getKey(), (ContentId)contentId, (byte)this.storeWorker.getPayload(op.getValue()), (ByteString)this.storeWorker.toStoreOnReferenceState(op.getValue())));
                if (this.storeWorker.requiresGlobalState(op.getValue())) {
                    Optional<Object> expectedValue;
                    ByteString newState = this.storeWorker.toStoreGlobalState(op.getValue());
                    if (op.getExpectedValue() != null) {
                        if (this.storeWorker.getType(op.getValue()) != this.storeWorker.getType(op.getExpectedValue())) {
                            throw new IllegalArgumentException(String.format("Content-type for conditional put-operation for key '%s' for 'value' and 'expectedValue' must be the same, but are '%s' and '%s'.", op.getKey(), this.storeWorker.getType(op.getValue()), this.storeWorker.getType(op.getExpectedValue())));
                        }
                        if (!contentId.equals(ContentId.of((String)this.storeWorker.getId(op.getExpectedValue())))) {
                            throw new IllegalArgumentException(String.format("Conditional put-operation key '%s' has different content-ids.", op.getKey()));
                        }
                        expectedValue = Optional.of(this.storeWorker.toStoreGlobalState(op.getExpectedValue()));
                    } else {
                        expectedValue = Optional.empty();
                    }
                    commitAttempt.putExpectedStates(contentId, expectedValue);
                    commitAttempt.putGlobal(contentId, newState);
                    continue;
                }
                if (op.getExpectedValue() == null) continue;
                throw new IllegalArgumentException(String.format("Content-type '%s' for put-operation for key '%s' does not support global state, expected-value not supported for this content-type.", this.storeWorker.getType(op.getValue()), op.getKey()));
            }
            if (operation instanceof Delete) {
                commitAttempt.addDeletes(operation.getKey());
                continue;
            }
            if (operation instanceof Unchanged) {
                commitAttempt.addUnchanged(operation.getKey());
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown operation type '%s'", operation));
        }
        return this.databaseAdapter.commit((CommitAttempt)commitAttempt.build());
    }

    public void transplant(BranchName targetBranch, Optional<Hash> referenceHash, List<Hash> sequenceToTransplant, Function<METADATA, METADATA> updateCommitMetadata) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.transplant(targetBranch, referenceHash, sequenceToTransplant, this.updateCommitMetadata(updateCommitMetadata));
    }

    public void merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash, Function<METADATA, METADATA> updateCommitMetadata) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.merge(fromHash, toBranch, expectedHash, this.updateCommitMetadata(updateCommitMetadata));
    }

    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.assign(ref, expectedHash, targetHash);
    }

    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.databaseAdapter.create(ref, targetHash.orElseGet(() -> ((DatabaseAdapter)this.databaseAdapter).noAncestorHash()));
    }

    public void delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.databaseAdapter.delete(ref, hash);
    }

    @Nonnull
    public ReferenceInfo<METADATA> getNamedRef(@Nonnull String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        ReferenceInfo namedRef = this.databaseAdapter.namedRef(ref, params);
        return namedRef.withUpdatedCommitMeta(this.deserializeMetadata((ByteString)namedRef.getHeadCommitMeta()));
    }

    public Stream<ReferenceInfo<METADATA>> getNamedRefs(GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.databaseAdapter.namedRefs(params).map(namedRef -> namedRef.withUpdatedCommitMeta(this.deserializeMetadata((ByteString)namedRef.getHeadCommitMeta())));
    }

    private Function<ByteString, ByteString> updateCommitMetadata(Function<METADATA, METADATA> updateCommitMetadata) {
        return original -> {
            METADATA commitMeta = this.deserializeMetadata((ByteString)original);
            Object updated = updateCommitMetadata.apply(commitMeta);
            return this.serializeMetadata(updated);
        };
    }

    private ByteString serializeMetadata(METADATA metadata) {
        return metadata != null ? this.storeWorker.getMetadataSerializer().toBytes(metadata) : null;
    }

    private METADATA deserializeMetadata(ByteString commitMeta) {
        return (METADATA)(commitMeta != null ? this.storeWorker.getMetadataSerializer().fromBytes(commitMeta) : null);
    }

    public Stream<Commit<METADATA, CONTENT>> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        Stream stream = this.databaseAdapter.commitLog(hash);
        BiConsumer<ImmutableCommit.Builder<METADATA, CONTENT>, CommitLogEntry> enhancer = this.enhancerForCommitLog(fetchAdditionalInfo);
        return stream.map(e -> {
            ImmutableCommit.Builder commit = Commit.builder().hash(e.getHash()).commitMeta(this.deserializeMetadata(e.getMetadata()));
            enhancer.accept((ImmutableCommit.Builder<METADATA, CONTENT>)commit, (CommitLogEntry)e);
            return commit.build();
        });
    }

    private BiConsumer<ImmutableCommit.Builder<METADATA, CONTENT>, CommitLogEntry> enhancerForCommitLog(boolean fetchAdditionalInfo) {
        if (!fetchAdditionalInfo) {
            return (a, b) -> {};
        }
        HashMap globalContents = new HashMap();
        BiFunction<ContentId, Byte, Optional> getGlobalContents = (contentId, type) -> {
            if (!this.storeWorker.requiresGlobalState(this.storeWorker.getType(type))) {
                return Optional.empty();
            }
            return globalContents.computeIfAbsent(contentId, cid -> this.databaseAdapter.globalContent(contentId).map(ContentIdAndBytes::getValue));
        };
        return (commitBuilder, logEntry) -> {
            if (!logEntry.getParents().isEmpty()) {
                commitBuilder.parentHash((Hash)logEntry.getParents().get(0));
            }
            logEntry.getDeletes().forEach(delete -> commitBuilder.addOperations((Operation)Delete.of((Key)delete)));
            logEntry.getPuts().forEach(put -> commitBuilder.addOperations((Operation)Put.of((Key)put.getKey(), (Object)this.storeWorker.valueFromStore(put.getValue(), (Optional)getGlobalContents.apply(put.getContentId(), put.getType())))));
        };
    }

    public Stream<WithType<Key, CONTENT_TYPE>> getKeys(Ref ref) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        return this.databaseAdapter.keys(hash, KeyFilterPredicate.ALLOW_ALL).map(kt -> WithType.of((Enum)this.storeWorker.getType(Byte.valueOf(kt.getType())), (Object)kt.getKey()));
    }

    public CONTENT getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        return this.getValues(ref, Collections.singletonList(key)).get(key);
    }

    public Map<Key, CONTENT> getValues(Ref ref, Collection<Key> keys) throws ReferenceNotFoundException {
        Hash hash = this.refToHash(ref);
        return this.databaseAdapter.values(hash, keys, KeyFilterPredicate.ALLOW_ALL).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.mapContentAndState((ContentAndState<ByteString>)((ContentAndState)e.getValue()))));
    }

    private CONTENT mapContentAndState(ContentAndState<ByteString> cs) {
        return (CONTENT)this.storeWorker.valueFromStore((ByteString)cs.getRefState(), Optional.ofNullable((ByteString)cs.getGlobalState()));
    }

    public Stream<Diff<CONTENT>> getDiffs(Ref from, Ref to) throws ReferenceNotFoundException {
        Hash fromHash = this.refToHash(from);
        Hash toHash = this.refToHash(to);
        return this.databaseAdapter.diff(fromHash, toHash, KeyFilterPredicate.ALLOW_ALL).map(d -> Diff.of((Key)d.getKey(), d.getFromValue().map(v -> this.storeWorker.valueFromStore(v, d.getGlobal())), d.getToValue().map(v -> this.storeWorker.valueFromStore(v, d.getGlobal()))));
    }

    private Hash refToHash(Ref ref) throws ReferenceNotFoundException {
        if (ref instanceof NamedRef) {
            return this.hashOnReference((NamedRef)ref, Optional.empty());
        }
        if (ref instanceof Hash) {
            return (Hash)ref;
        }
        throw new IllegalArgumentException(String.format("Unsupported reference '%s'", ref));
    }

    public Stream<RefLogDetails> getRefLog(Hash refLogId) throws RefLogNotFoundException {
        Stream refLogStream = this.databaseAdapter.refLog(refLogId);
        return refLogStream.map(e -> ImmutableRefLogDetails.builder().refLogId(e.getRefLogId()).refName(e.getRefName()).refType(e.getRefType()).commitHash(e.getCommitHash()).parentRefLogId((Hash)e.getParents().get(0)).operationTime(e.getOperationTime()).operation(e.getOperation()).sourceHashes((Iterable)e.getSourceHashes()).build());
    }
}

